Imports System.EnterpriseServices
Imports System.Text
Imports System.Reflection
Imports System.Threading
Imports System.Windows.Forms


'<EventTrackingEnabled(), _
' JustInTimeActivation()> _
'<EventTrackingEnabled(), _
' ObjectPooling(MinPoolSize:=2, MaxPoolSize:=4)> _
'<EventTrackingEnabled(), _
' JustInTimeActivation(), _
' ObjectPooling(MinPoolSize:=2, MaxPoolSize:=4)> _
<EventTrackingEnabled(), _
 ConstructionEnabled(Default:="Domylny acuch znakw")> _
Public Class MyComponent
    Inherits ServicedComponent
    Implements IMyInterface

    Private m_GlobalCounter As Integer
    Private m_Counter As Integer
    Private m_ConstructionString As String

    Public Sub New()
        m_GlobalCounter = 0 'Symulacja inicjalizacji globalnych zasobw.
        m_Counter = -1      'Symulacja braku inicjalizacji zasobw klienta.
        DisplayTraceMessageBox()
    End Sub

    Protected Overrides Sub Construct(ByVal s As String)
        m_ConstructionString = s
        DisplayTraceMessageBox()
    End Sub

    Protected Overrides Sub Finalize()
        m_GlobalCounter = -1 'Symulacja zwolnienia globalnych zasobw.
        DisplayTraceMessageBox()
    End Sub

    <AutoComplete()> _
    Private Sub Method1() Implements IMyInterface.Method1
        m_GlobalCounter += 1
        m_Counter += 1
        DisplayTraceMessageBox()
    End Sub

    Protected Overrides Sub Activate()
        m_Counter = 0       'Symulacja inicjalizacji zasobw klienta.
        DisplayTraceMessageBox()
    End Sub

    Protected Overrides Sub Deactivate()
        m_Counter = -1      'Symulacja braka zwalniania zasobw specyficznych dla klienta.
        DisplayTraceMessageBox()
    End Sub

    Protected Overrides Function CanBePooled() As Boolean
        DisplayTraceMessageBox()
        Return DialogResult.Yes = MessageBox.Show( _
           "Czy zwrci obiekt do puli?", _
           "CanBePooled", MessageBoxButtons.YesNo)
    End Function

    Private Sub DisplayTraceMessageBox()
        Dim className As String
        Dim methodName As String
        Dim details As New StringBuilder
        Dim sf As New StackFrame(1) 'Pobranie ramki stosu wywoujcej metody.
        Dim mi As MethodBase = sf.GetMethod() 'Informacje o wywoujcej metodzie.
        className = mi.DeclaringType.Name 'Klasa wywoujcej metody.
        methodName = mi.Name 'Nazwa wywoujcej metody.
        details.Append(className)
        details.Append(".")
        details.Append(methodName)
        details.Append(Environment.NewLine)
        details.Append("   acuch znakw do konstrukcji=")
        details.Append(m_ConstructionString)
        details.Append(Environment.NewLine)
        details.Append("   m_Counter=")
        details.Append(m_Counter)
        details.Append(Environment.NewLine)
        details.Append("   m_GlobalCounter=")
        details.Append(m_GlobalCounter)
        details.Append(Environment.NewLine)
        details.Append("   Proces=")
        details.Append(Process.GetCurrentProcess().Id)
        details.Append(Environment.NewLine)
        details.Append("   Wtek=")
        details.Append(Thread.CurrentThread.GetHashCode().ToString())
        Try
            details.Append(Environment.NewLine)
            details.Append("   Kontekst=")
            'Zgoszenie wyjtku COM, jeli nie zadano adnej usugi.
            Dim contextID As Guid = ContextUtil.ContextId
            details.Append(ContextUtil.ContextId.ToString())
        Catch ex As Exception
            'Przechwycenie wyjtku, jeli brak kontekstu (nie zadano adnej usugi).
            details.Append("<Brak>")
        End Try
        MessageBox.Show(details.ToString(), _
           "Szczegy wywoania")
    End Sub


End Class

