Imports System.EnterpriseServices
Imports System.Text
Imports System.Threading
Imports System.Windows.Forms

Public Class FirstServicedComponent
   Inherits ServicedComponent
   Implements IFirstServicedComponent

   Private Sub Method1() Implements IFirstServicedComponent.Method1
      Dim details As New StringBuilder
      details.Append("Process=")
      details.Append(Process.GetCurrentProcess().Id)
      details.Append(Environment.NewLine)
      details.Append("Thread=")
      details.Append(Thread.CurrentThread.GetHashCode().ToString())
      Try
         details.Append(Environment.NewLine)
         details.Append("Context=")
         'Throws COM Exception if zero services requested
         Dim contextID As Guid = ContextUtil.ContextId
         details.Append(ContextUtil.ContextId.ToString())
      Catch ex As Exception
         'Catches exception if no context (zero services requested)
         details.Append("<None>")
      End Try
      MessageBox.Show(details.ToString(), _
         "FirstServicedComponent.Method1 Called")
   End Sub
End Class
