Imports System.EnterpriseServices
Imports System.Text
Imports System.Threading
Imports System.Windows.Forms

<EventTrackingEnabled(), _
 Description("A sample component")> _
Public Class MyComponent
   Inherits ServicedComponent
   Implements IMyInterface

   Private Sub Method1() Implements IMyInterface.Method1
      DisplayTraceMessageBox(Me.GetType().ToString(), "Method1")
   End Sub

   Private Sub DisplayTraceMessageBox(ByVal className As String, ByVal methodName As String)
      Dim details As New StringBuilder
      details.Append("In ")
      details.Append(className)
      details.Append(".")
      details.Append(methodName)
      details.Append(Environment.NewLine)
      details.Append("   Process=")
      details.Append(Process.GetCurrentProcess().Id)
      details.Append(Environment.NewLine)
      details.Append("   Thread=")
      details.Append(Thread.CurrentThread.GetHashCode().ToString())
      Try
         details.Append(Environment.NewLine)
         details.Append("   Context=")
         'Throws COM Exception if zero services requested
         Dim contextID As Guid = ContextUtil.ContextId
         details.Append(ContextUtil.ContextId.ToString())
      Catch ex As Exception
         'Catches exception if no context (zero services requested)
         details.Append("<None>")
      End Try
      MessageBox.Show(details.ToString(), _
         "Show Method Call Detail")
   End Sub

End Class

