Imports System.EnterpriseServices
Imports System.Text
Imports System.Threading
Imports System.Windows.Forms

Public Class MyComponent
   Inherits ServicedComponent
   Implements IMyInterface

   Private Sub Method1() Implements IMyInterface.Method1
      DisplayTraceMessageBox(Me.GetType().ToString(), "Method1")
   End Sub

    Private Sub DisplayTraceMessageBox(ByVal className As String, ByVal methodName As String)
        Dim details As New StringBuilder
        details.Append("W ")
        details.Append(className)
        details.Append(".")
        details.Append(methodName)
        details.Append(Environment.NewLine)
        details.Append("   Proces=")
        details.Append(Process.GetCurrentProcess().Id)
        details.Append(Environment.NewLine)
        details.Append("   Wtek=")
        details.Append(Thread.CurrentThread.GetHashCode().ToString())
        Try
            details.Append(Environment.NewLine)
            details.Append("   Kontekst=")
            'Zgoszenie wyjtku COM, jeli nie zadano adnych usug.
            Dim contextID As Guid = ContextUtil.ContextId
            details.Append(ContextUtil.ContextId.ToString())
        Catch ex As Exception
            'Przechwycenie wyjtku, jeli nie ma kontekstu (nie zadano usug).
            details.Append("<Brak>")
        End Try
        MessageBox.Show(details.ToString(), _
           "Szczegy wywoania metody")
    End Sub
End Class


