Imports System.Runtime.Remoting.Contexts
Imports System.Runtime.Remoting.Lifetime

<Synchronization(SynchronizationAttribute.REQUIRES_NEW)> _
Public Class Sponsor
    Inherits ContextBoundObject 'Odziedziczony po MarshalByRefObject.
   Implements ISponsor, IDisposable

   Private m_LeaseList As Hashtable
   Private m_Disposed As Boolean

   Public Sub New()
      m_Disposed = False
      m_LeaseList = New Hashtable(8)
      Dim s As New ClientSponsor
   End Sub

   Public Function Renewal(ByVal lease As _
         System.Runtime.Remoting.Lifetime.ILease) As System.TimeSpan _
         Implements ISponsor.Renewal
      Return lease.InitialLeaseTime
   End Function

   Public Sub Register(ByVal obj As MarshalByRefObject)
      If Not m_Disposed Then
            'Obiektu mona uywa, jeli nie zosta usunity.
         Dim lease As ILease
         lease = CType(obj.GetLifetimeService(), ILease)
         If Not lease Is Nothing Then
                'Obiekt jest powizany z dzieraw.
            If Not m_LeaseList.Contains(lease) Then
                    'Zarejestrowa mona tylko raz.
               lease.Register(Me)
               m_LeaseList.Add(obj, Nothing)
            End If
         End If
      End If
   End Sub

   Public Sub Unregister(ByVal obj As MarshalByRefObject)
      If Not m_Disposed Then
            'Obiektu mona uywa, jeli nie zosta usunity.
         Try
            Dim lease As ILease
            lease = CType(obj.GetLifetimeService(), ILease)
            If Not lease Is Nothing Then
                    'Obiekt jest powizany z dzieraw.
               If m_LeaseList.Contains(obj) Then
                        'Wyrejestrowa mona tylko raz.
                  lease.Unregister(Me)
                  m_LeaseList.Remove(obj)
               End If
            End If
         Catch ex As Exception
                'Zdalny obiekt ju nie istnieje.
         Finally
            If m_LeaseList.Contains(obj) Then
                    'Usunicie z listy.
               m_LeaseList.Remove(obj)
            End If
         End Try
      End If
   End Sub

   Public Sub Dispose() Implements System.IDisposable.Dispose
      Dispose(True)
   End Sub

   Protected Overrides Sub Finalize()
      Dispose(False)
   End Sub

   Private Sub Dispose(ByVal disposing As Boolean)
      If Not m_Disposed Then
            'Nie mona usun dwukrotnie.
         Try
            For Each leaseObject As Object In m_LeaseList
                    'Wyrejestrowanie wszystkich sponsorw dzierawy.
               Dim lease As ILease = CType(leaseObject, ILease)
               If Not lease Is Nothing Then
                  lease.Unregister(Me)
               End If
            Next
         Catch ex As Exception
                'Zdalny obiekt ju nie istnieje.
         Finally
            m_LeaseList.Clear()
                'Zapobieganie wielokrotnemu usuwaniu.
            m_Disposed = True
            If disposing Then
                    'Powstrzymanie finalizacji, poniewa metoda Dispose zakoczya operacje porzdkujce.
               GC.SuppressFinalize(Me)
            End If
         End Try
      End If
   End Sub

End Class
