Imports System.Runtime.Remoting
Imports System.Runtime.Remoting.Lifetime
Imports System.Windows.Forms

Public Class TestClass
   Inherits MarshalByRefObject

   Private m_Counter As Integer
   Public Event UpdateEvent(ByVal counter As Integer)

   Public Sub New()
      m_Counter = 0
      Dim app As AppDomain = AppDomain.CurrentDomain
      MessageBox.Show("New", "TestClass(" + app.FriendlyName + ")")
   End Sub

   Public Sub TestMethod()
      m_Counter += 1
      RaiseEvent UpdateEvent(m_Counter)
      Dim app As AppDomain = AppDomain.CurrentDomain
        MessageBox.Show("TestMethod: Licznik=" + m_Counter.ToString(), _
           "TestClass(" + app.FriendlyName + ")")

        'Jawne odnawianie
      'Dim lease As ILease
      'lease = CType(RemotingServices.GetLifetimeService(Me), ILease)
        'lease.Renew(lease.InitialLeaseTime) 'Uycie pocztkowego limitu to dobre rozwizanie.

   End Sub

    'Uywany do obiektw typu singleton.
   'Public Overrides Function InitializeLifetimeService() As Object
   '   Return Nothing
   'End Function

    'Uywany do obiektw aktywowanych przez klienta.
   Public Overrides Function InitializeLifetimeService() As Object
      Dim lease As ILease
      lease = CType(MyBase.InitializeLifetimeService(), ILease)
        lease.InitialLeaseTime = TimeSpan.FromSeconds(20) 'Test: krtki czas.
      lease.RenewOnCallTime = lease.InitialLeaseTime
      lease.SponsorshipTimeout = TimeSpan.FromSeconds(10)
      Return lease
   End Function

End Class
