Imports System.Security.Principal

Public Class UnleashedPrincipal
   Implements IPrincipal

   Private m_Identity As IIdentity

   Public Sub New(ByRef identity As IIdentity)
      m_Identity = identity
   End Sub

   Public Overridable ReadOnly Property Identity() As IIdentity _
      Implements IPrincipal.Identity
      Get
         Return m_Identity
      End Get
   End Property

   Public Overridable Function IsInRole(ByVal role As String) As Boolean _
      Implements IPrincipal.IsInRole
      If m_Identity.IsAuthenticated Then
         Dim userName As String = m_Identity.Name
            'Sprawdzenie w bazie danych lub, jak w przykadzie, wykorzystanie sztywno podanych wartoci.
         Select Case role
            Case "TestUser"
               Return True
            Case "PrivilegedTestUser"
               Return True
            Case "SuperTestUser"
               Return False
            Case Else
               Return False
         End Select
      Else
         Return False
      End If
   End Function
End Class
