Imports System.IO
Imports System.Xml
Imports System.Xml.Serialization
Module XMLSerialization
   Sub Main()
      'Utworzenie obiektu Customer.
      Dim cus As Customer
      cus = New Customer(10, "Jan Kowalski")
      cus.CreditLimit = 1000.0
      'Utworzenie obiektu XmlSerializer do serializacji obiektw typu Customer.
      Dim ser As XmlSerializer
      ser = New XmlSerializer(cus.GetType())
      'Otwarcie pliku, do ktrego przesyane s dane.
      Dim fs As FileStream
      fs = File.Create("Customer.xml")

      'Utworzenie strumienia do zapisu danych w formacie XML.
      Dim xtw As XmlTextWriter
      xtw = New XmlTextWriter(fs, System.Text.Encoding.UTF8)
      xtw.Formatting = Formatting.Indented

      'Serializacja obiektu.
      ser.Serialize(xtw, cus)
      'Operacje porzdkujce.
      cus = Nothing
      xtw.Close()
      fs.Close()

      'Deserializacja obiektu Customer.
      fs = File.OpenRead("Customer.xml")
      cus = ser.Deserialize(fs)
      'Operacje porzdkujce.
      fs.Close()
      'Wywietlenie zawartoci obiektu Customer.
        Console.WriteLine("Numer identyfikacyjny : {0}", cus.Id)
        Console.WriteLine("Imi i nazwisko       : {0}", cus.Name)
        Console.WriteLine("Limit kredytu         : {0}", cus.CreditLimit)
   End Sub

End Module
