Imports System.IO
Imports System.Runtime.Serialization.Formatters.Soap
Imports System.Runtime.Serialization.Formatters.Binary

Module CustomSerialization

    Sub Main()
        ' Otwarcie strumienia.
        Dim stream As FileStream = File.Create("customer.xml")
        Dim cus As Customer
        cus = New Customer(10, "Jan Kowalski")
        cus.CreditLimit = 1000.0

        ' Tworzenie formatera SoapFormatter.
        Dim soapFmt As New SoapFormatter
        soapFmt.Serialize(stream, cus)

        ' Operacje porzdkujce.
        cus = Nothing
        stream.Close()

        ' Otwarcie strumienia.
        stream = File.Open("customer.xml", FileMode.Open)
        cus = soapFmt.Deserialize(stream)
        ' Operacje porzdkujce.
        stream.Close()

        ' Wywietla zawarto obiektu Customer.
        Console.WriteLine("Numer identyfikacyjny  : {0}", cus.Id)
        Console.WriteLine("Imi i nazwisko        : {0}", cus.Name)
        Console.WriteLine("Limit kredytu          : {0}", cus.CreditLimit)
    End Sub

End Module
