Imports System.ComponentModel
Imports System.Web.UI
Imports System.Collections.Specialized

Public Class LoginForm2
  Inherits System.Web.UI.WebControls.WebControl
  Implements IPostBackDataHandler, IPostBackEventHandler

  Dim m_username As String
  Dim m_password As String

  <Bindable(True), Category("Appearance"), DefaultValue("")> Property Username() As String
    Get
      Return m_username
    End Get
    Set(ByVal Value As String)
      m_username = Value
    End Set
  End Property

  <Bindable(True), Category("Appearance"), DefaultValue("")> Property Password() As String
    Get
      Return m_password
    End Get
    Set(ByVal Value As String)
      m_password = Value
    End Set
  End Property

  Public Event Submit As EventHandler

  Public Overridable Sub OnSubmit(ByVal e As EventArgs)
    RaiseEvent Submit(Me, e)
  End Sub

  Public Function LoadPostData(ByVal postDataKey As String, ByVal postCollection As NameValueCollection) As Boolean Implements IPostBackDataHandler.LoadPostData
    m_username = postCollection(Me.UniqueID + "_Username")
    m_password = postCollection(Me.UniqueID + "_Password")
    'Page.RegisterRequiresRaiseEvent(Me)
    Return False
  End Function

  Public Sub RaisePostDataChangedEvent() Implements IPostBackDataHandler.RaisePostDataChangedEvent
    'nic nie rb
  End Sub

  Public Sub RaisePostBackEvent(ByVal eventArgument As String) Implements IPostBackEventHandler.RaisePostBackEvent
    OnSubmit(EventArgs.Empty)
  End Sub

  Protected Overrides Sub Render(ByVal output As System.Web.UI.HtmlTextWriter)
    output.Write("<table><tr><td>Uytkownik: </td><td>")
    output.Write("<input type=text name=""" & Me.UniqueID & "_Username"" Value=""" & _
        m_username & """>")
    output.Write("</td></tr><tr><td>Haso: </td><td>")
    output.Write("<input type=password name=""" & Me.UniqueID & "_Password"" value=""" & _
        m_password & """>")
    output.Write("</td></tr><tr><td colspan=2>")
    'output.Write("<input type=""submit"" name=""" & Me.UniqueID & """ " & _
    '    "value=""Submit"">")
    output.Write("<input type=""button"" OnClick=""jscript:" & _
        Page.GetPostBackEventReference(Me, "Submit") & """ value=""Submit"">")

    output.Write("</td></tr></table>")
  End Sub

End Class
