Imports System.ComponentModel

Public Class Product
  Implements IEditableObject

  Structure ProductData
    Friend ProductId As Guid
    Friend ProductName As String
    Friend UnitsInStock As Int16
    Friend UnitsOnOrder As Int16
    Friend ReorderLevel As Int16
    Friend Changed As Boolean
    Friend Added As Boolean
    Friend ChangedDuringThisEdit As Boolean
  End Structure

  Public m_colContainingCollection As Products
  Private m_ProdData As ProductData
  Private m_BackupData As ProductData
  Private m_blnEditInProgress As Boolean = False

  Sub BeginEdit() Implements IEditableObject.BeginEdit
    If Not m_blnEditInProgress Then
      m_BackupData = m_ProdData
      m_blnEditInProgress = True
      m_ProdData.ChangedDuringThisEdit = False
    End If
  End Sub

  Sub CancelEdit() Implements IEditableObject.CancelEdit
    If m_blnEditInProgress Then
      Me.m_ProdData = m_BackupData
      m_blnEditInProgress = False
    End If
  End Sub

  Sub EndEdit() Implements IEditableObject.EndEdit
    If m_blnEditInProgress Then
      m_BackupData = New ProductData
      m_blnEditInProgress = False
    End If

    If Me.m_ProdData.ChangedDuringThisEdit Then
      Me.OnProductChanged()
    End If
  End Sub

  Public Sub New(ByVal pguiProductId As Guid)
    Me.m_ProdData = New ProductData
    Me.m_ProdData.ProductId = pguiProductId
    Me.m_ProdData.ProductName = ""
    Me.m_ProdData.UnitsInStock = 0
    Me.m_ProdData.UnitsOnOrder = 0
    Me.m_ProdData.ReorderLevel = 0
    Me.m_ProdData.Changed = False
    Me.m_ProdData.Added = False
    Me.m_ProdData.ChangedDuringThisEdit = False
  End Sub

  Public Sub New( _
      ByVal pintProductId As Int32, _
      ByVal pstrProductName As String, _
      ByVal pintUnitsInStock As Int16, _
      ByVal pintUnitsOnOrder As Int16, _
      ByVal pintReorderLevel As Int16)

    Me.m_ProdData = New ProductData
    Me.m_ProdData.ProductId = ProductID
    Me.m_ProdData.ProductName = pstrProductName
    Me.m_ProdData.UnitsInStock = pintUnitsInStock
    Me.m_ProdData.UnitsOnOrder = pintUnitsOnOrder
    Me.m_ProdData.ReorderLevel = pintReorderLevel
    Me.m_ProdData.Changed = False
    Me.m_ProdData.Added = False
    Me.m_ProdData.ChangedDuringThisEdit = False

  End Sub

  Public ReadOnly Property ProductID() As Guid
    Get
      Return Me.m_ProdData.ProductId
    End Get
  End Property

  Public Property ProductName() As String
    Get
      ProductName = Me.m_ProdData.ProductName
    End Get
    Set(ByVal Value As String)
      If Not Me.m_ProdData.ProductName.Equals(Value) Then
        Me.m_ProdData.ProductName = Value
        If Me.m_blnEditInProgress Then
          Me.m_ProdData.ChangedDuringThisEdit = True
          Me.m_ProdData.Changed = True
        End If
      End If
    End Set
  End Property

  Public Property UnitsInStock() As Int16
    Get
      UnitsInStock = Me.m_ProdData.UnitsInStock
    End Get
    Set(ByVal Value As Int16)
      If Not Me.m_ProdData.UnitsInStock.Equals(Value) Then
        Me.m_ProdData.UnitsInStock = Value
        If Me.m_blnEditInProgress Then
          Me.m_ProdData.ChangedDuringThisEdit = True
          Me.m_ProdData.Changed = True
        End If
      End If
    End Set
  End Property

  Public Property UnitsOnOrder() As Int16
    Get
      UnitsOnOrder = Me.m_ProdData.UnitsOnOrder
    End Get
    Set(ByVal Value As Int16)
      If Not Me.m_ProdData.UnitsOnOrder.Equals(Value) Then
        Me.m_ProdData.UnitsOnOrder = Value
        If Me.m_blnEditInProgress Then
          Me.m_ProdData.ChangedDuringThisEdit = True
          Me.m_ProdData.Changed = True
        End If
      End If
    End Set
  End Property

  Public Property ReorderLevel() As Int16
    Get
      ReorderLevel = Me.m_ProdData.ReorderLevel
    End Get
    Set(ByVal Value As Int16)
      If Not Me.m_ProdData.ReorderLevel.Equals(Value) Then
        Me.m_ProdData.ReorderLevel = Value
        If Me.m_blnEditInProgress Then
          Me.m_ProdData.ChangedDuringThisEdit = True
          Me.m_ProdData.Changed = True
        End If
      End If
    End Set
  End Property

  Friend Property ContainingCollection() As Products
    Get
      Return m_colContainingCollection
    End Get
    Set(ByVal Value As Products)
      m_colContainingCollection = Value
    End Set
  End Property

  Private Sub OnProductChanged()
    If Not m_blnEditInProgress And Not (m_colContainingCollection Is Nothing) Then
      m_colContainingCollection.ProductChanged(Me)
    End If
  End Sub

  Public Property Changed() As Boolean
    Get
      Return m_ProdData.Changed
    End Get
    Set(ByVal Value As Boolean)
      m_ProdData.Changed = Value
    End Set
  End Property

  Public Property Added() As Boolean
    Get
      Return m_ProdData.Added
    End Get
    Set(ByVal Value As Boolean)
      m_ProdData.Added = Value
    End Set
  End Property

End Class

