Public Class frmMain
  Inherits System.Windows.Forms.Form

  Dim m_arlProducts As ArrayList
  Dim m_intPosition As Int32 = 0
  Dim m_objData As Data

  'Declare strongly typed DataSet object; this will permit
  'bindings to be set using strongly-typed syntax, e.g.
  '       BindingContext(m_arlProducts)
  'instead of
  '       BindingContext(Me.m_dsData, "Products")

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.IContainer

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  Friend WithEvents btnNavFirst As System.Windows.Forms.Button
  Friend WithEvents btnNavPrev As System.Windows.Forms.Button
  Friend WithEvents lblNavLocation As System.Windows.Forms.Label
  Friend WithEvents btnNavNext As System.Windows.Forms.Button
  Friend WithEvents btnNavLast As System.Windows.Forms.Button
  Friend WithEvents txtProductName As System.Windows.Forms.TextBox
  Friend WithEvents txtQtyOnHand As System.Windows.Forms.TextBox
  Friend WithEvents txtQtyOnOrder As System.Windows.Forms.TextBox
  Friend WithEvents txtReorderLevel As System.Windows.Forms.TextBox
  Friend WithEvents grpLoadRecords As System.Windows.Forms.GroupBox
  Friend WithEvents btnRetrieveRecords As System.Windows.Forms.Button
  Friend WithEvents nudMinimumReorderLevel As System.Windows.Forms.NumericUpDown
  Friend WithEvents lblProduct As System.Windows.Forms.Label
  Friend WithEvents lblQtyOnHand As System.Windows.Forms.Label
  Friend WithEvents lblQtyOnOrder As System.Windows.Forms.Label
  Friend WithEvents lblReorderLevel As System.Windows.Forms.Label
  Friend WithEvents lblSpecifyMinRecorder As System.Windows.Forms.Label
  Friend WithEvents lblDataGridView As System.Windows.Forms.Label
  Friend WithEvents chkDiscontinued As System.Windows.Forms.CheckBox
  Friend WithEvents grdProducts As System.Windows.Forms.DataGrid
  Friend WithEvents btnAdd As System.Windows.Forms.Button
  Friend WithEvents btnDelete As System.Windows.Forms.Button
  Friend WithEvents btnCancel As System.Windows.Forms.Button
  Friend WithEvents Label1 As System.Windows.Forms.Label
  Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
  Friend WithEvents mnuFile As System.Windows.Forms.MenuItem
  Friend WithEvents mnuFile_Exit As System.Windows.Forms.MenuItem
  Friend WithEvents mnuHelp As System.Windows.Forms.MenuItem
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.txtProductName = New System.Windows.Forms.TextBox
    Me.txtQtyOnHand = New System.Windows.Forms.TextBox
    Me.txtQtyOnOrder = New System.Windows.Forms.TextBox
    Me.txtReorderLevel = New System.Windows.Forms.TextBox
    Me.lblProduct = New System.Windows.Forms.Label
    Me.lblQtyOnHand = New System.Windows.Forms.Label
    Me.lblQtyOnOrder = New System.Windows.Forms.Label
    Me.lblReorderLevel = New System.Windows.Forms.Label
    Me.btnNavFirst = New System.Windows.Forms.Button
    Me.btnNavPrev = New System.Windows.Forms.Button
    Me.lblNavLocation = New System.Windows.Forms.Label
    Me.btnNavNext = New System.Windows.Forms.Button
    Me.btnNavLast = New System.Windows.Forms.Button
    Me.grpLoadRecords = New System.Windows.Forms.GroupBox
    Me.btnRetrieveRecords = New System.Windows.Forms.Button
    Me.lblSpecifyMinRecorder = New System.Windows.Forms.Label
    Me.nudMinimumReorderLevel = New System.Windows.Forms.NumericUpDown
    Me.lblDataGridView = New System.Windows.Forms.Label
    Me.chkDiscontinued = New System.Windows.Forms.CheckBox
    Me.grdProducts = New System.Windows.Forms.DataGrid
    Me.btnAdd = New System.Windows.Forms.Button
    Me.btnDelete = New System.Windows.Forms.Button
    Me.btnCancel = New System.Windows.Forms.Button
    Me.Label1 = New System.Windows.Forms.Label
    Me.MainMenu1 = New System.Windows.Forms.MainMenu
    Me.mnuFile = New System.Windows.Forms.MenuItem
    Me.mnuFile_Exit = New System.Windows.Forms.MenuItem
    Me.mnuHelp = New System.Windows.Forms.MenuItem
    Me.grpLoadRecords.SuspendLayout()
    CType(Me.nudMinimumReorderLevel, System.ComponentModel.ISupportInitialize).BeginInit()
    CType(Me.grdProducts, System.ComponentModel.ISupportInitialize).BeginInit()
    Me.SuspendLayout()
    '
    'txtProductName
    '
    Me.txtProductName.Location = New System.Drawing.Point(112, 96)
    Me.txtProductName.Name = "txtProductName"
    Me.txtProductName.Size = New System.Drawing.Size(144, 20)
    Me.txtProductName.TabIndex = 2
    Me.txtProductName.Text = ""
    '
    'txtQtyOnHand
    '
    Me.txtQtyOnHand.Location = New System.Drawing.Point(376, 96)
    Me.txtQtyOnHand.Name = "txtQtyOnHand"
    Me.txtQtyOnHand.Size = New System.Drawing.Size(40, 20)
    Me.txtQtyOnHand.TabIndex = 4
    Me.txtQtyOnHand.Text = ""
    '
    'txtQtyOnOrder
    '
    Me.txtQtyOnOrder.Location = New System.Drawing.Point(376, 128)
    Me.txtQtyOnOrder.Name = "txtQtyOnOrder"
    Me.txtQtyOnOrder.Size = New System.Drawing.Size(40, 20)
    Me.txtQtyOnOrder.TabIndex = 7
    Me.txtQtyOnOrder.Text = ""
    '
    'txtReorderLevel
    '
    Me.txtReorderLevel.Location = New System.Drawing.Point(376, 160)
    Me.txtReorderLevel.Name = "txtReorderLevel"
    Me.txtReorderLevel.Size = New System.Drawing.Size(40, 20)
    Me.txtReorderLevel.TabIndex = 9
    Me.txtReorderLevel.Text = ""
    '
    'lblProduct
    '
    Me.lblProduct.Location = New System.Drawing.Point(24, 96)
    Me.lblProduct.Name = "lblProduct"
    Me.lblProduct.Size = New System.Drawing.Size(80, 23)
    Me.lblProduct.TabIndex = 1
    Me.lblProduct.Text = "Towar"
    '
    'lblQtyOnHand
    '
    Me.lblQtyOnHand.Location = New System.Drawing.Point(288, 96)
    Me.lblQtyOnHand.Name = "lblQtyOnHand"
    Me.lblQtyOnHand.Size = New System.Drawing.Size(80, 23)
    Me.lblQtyOnHand.TabIndex = 3
    Me.lblQtyOnHand.Text = "Ilo w mag."
    '
    'lblQtyOnOrder
    '
    Me.lblQtyOnOrder.Location = New System.Drawing.Point(288, 128)
    Me.lblQtyOnOrder.Name = "lblQtyOnOrder"
    Me.lblQtyOnOrder.Size = New System.Drawing.Size(80, 23)
    Me.lblQtyOnOrder.TabIndex = 6
    Me.lblQtyOnOrder.Text = "Ilo w zam."
    '
    'lblReorderLevel
    '
    Me.lblReorderLevel.Location = New System.Drawing.Point(288, 160)
    Me.lblReorderLevel.Name = "lblReorderLevel"
    Me.lblReorderLevel.Size = New System.Drawing.Size(80, 23)
    Me.lblReorderLevel.TabIndex = 8
    Me.lblReorderLevel.Text = "Poziom zam."
    '
    'btnNavFirst
    '
    Me.btnNavFirst.Location = New System.Drawing.Point(88, 200)
    Me.btnNavFirst.Name = "btnNavFirst"
    Me.btnNavFirst.Size = New System.Drawing.Size(40, 23)
    Me.btnNavFirst.TabIndex = 10
    Me.btnNavFirst.Text = "<<"
    '
    'btnNavPrev
    '
    Me.btnNavPrev.Location = New System.Drawing.Point(128, 200)
    Me.btnNavPrev.Name = "btnNavPrev"
    Me.btnNavPrev.Size = New System.Drawing.Size(35, 23)
    Me.btnNavPrev.TabIndex = 11
    Me.btnNavPrev.Text = "<"
    '
    'lblNavLocation
    '
    Me.lblNavLocation.BackColor = System.Drawing.Color.White
    Me.lblNavLocation.Location = New System.Drawing.Point(168, 200)
    Me.lblNavLocation.Name = "lblNavLocation"
    Me.lblNavLocation.Size = New System.Drawing.Size(95, 23)
    Me.lblNavLocation.TabIndex = 12
    Me.lblNavLocation.Text = "Brak rekordw"
    Me.lblNavLocation.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
    '
    'btnNavNext
    '
    Me.btnNavNext.Location = New System.Drawing.Point(264, 200)
    Me.btnNavNext.Name = "btnNavNext"
    Me.btnNavNext.Size = New System.Drawing.Size(35, 23)
    Me.btnNavNext.TabIndex = 13
    Me.btnNavNext.Text = ">"
    '
    'btnNavLast
    '
    Me.btnNavLast.Location = New System.Drawing.Point(296, 200)
    Me.btnNavLast.Name = "btnNavLast"
    Me.btnNavLast.Size = New System.Drawing.Size(40, 23)
    Me.btnNavLast.TabIndex = 14
    Me.btnNavLast.Text = ">>"
    '
    'grpLoadRecords
    '
    Me.grpLoadRecords.Controls.Add(Me.btnRetrieveRecords)
    Me.grpLoadRecords.Controls.Add(Me.lblSpecifyMinRecorder)
    Me.grpLoadRecords.Controls.Add(Me.nudMinimumReorderLevel)
    Me.grpLoadRecords.Location = New System.Drawing.Point(8, 16)
    Me.grpLoadRecords.Name = "grpLoadRecords"
    Me.grpLoadRecords.Size = New System.Drawing.Size(408, 64)
    Me.grpLoadRecords.TabIndex = 0
    Me.grpLoadRecords.TabStop = False
    Me.grpLoadRecords.Text = "adowanie rekordw"
    '
    'btnRetrieveRecords
    '
    Me.btnRetrieveRecords.Location = New System.Drawing.Point(280, 24)
    Me.btnRetrieveRecords.Name = "btnRetrieveRecords"
    Me.btnRetrieveRecords.Size = New System.Drawing.Size(120, 23)
    Me.btnRetrieveRecords.TabIndex = 2
    Me.btnRetrieveRecords.Text = "Pobierz rekordy"
    '
    'lblSpecifyMinRecorder
    '
    Me.lblSpecifyMinRecorder.Location = New System.Drawing.Point(8, 33)
    Me.lblSpecifyMinRecorder.Name = "lblSpecifyMinRecorder"
    Me.lblSpecifyMinRecorder.Size = New System.Drawing.Size(200, 23)
    Me.lblSpecifyMinRecorder.TabIndex = 0
    Me.lblSpecifyMinRecorder.Text = "Okrel minimalny poziom zamwienia"
    '
    'nudMinimumReorderLevel
    '
    Me.nudMinimumReorderLevel.Increment = New Decimal(New Integer() {5, 0, 0, 0})
    Me.nudMinimumReorderLevel.Location = New System.Drawing.Point(216, 24)
    Me.nudMinimumReorderLevel.Name = "nudMinimumReorderLevel"
    Me.nudMinimumReorderLevel.Size = New System.Drawing.Size(48, 20)
    Me.nudMinimumReorderLevel.TabIndex = 1
    Me.nudMinimumReorderLevel.Value = New Decimal(New Integer() {5, 0, 0, 0})
    '
    'lblDataGridView
    '
    Me.lblDataGridView.Location = New System.Drawing.Point(24, 328)
    Me.lblDataGridView.Name = "lblDataGridView"
    Me.lblDataGridView.Size = New System.Drawing.Size(392, 23)
    Me.lblDataGridView.TabIndex = 15
    Me.lblDataGridView.Text = "Podgld towarw w formancie DataGrid (Tylko do odczytu)"
    Me.lblDataGridView.TextAlign = System.Drawing.ContentAlignment.BottomLeft
    '
    'chkDiscontinued
    '
    Me.chkDiscontinued.Location = New System.Drawing.Point(112, 128)
    Me.chkDiscontinued.Name = "chkDiscontinued"
    Me.chkDiscontinued.TabIndex = 5
    Me.chkDiscontinued.Text = "Wycofany"
    '
    'grdProducts
    '
    Me.grdProducts.DataMember = ""
    Me.grdProducts.HeaderForeColor = System.Drawing.SystemColors.ControlText
    Me.grdProducts.Location = New System.Drawing.Point(24, 360)
    Me.grdProducts.Name = "grdProducts"
    Me.grdProducts.ReadOnly = True
    Me.grdProducts.Size = New System.Drawing.Size(408, 144)
    Me.grdProducts.TabIndex = 16
    '
    'btnAdd
    '
    Me.btnAdd.ForeColor = System.Drawing.Color.Maroon
    Me.btnAdd.Location = New System.Drawing.Point(72, 232)
    Me.btnAdd.Name = "btnAdd"
    Me.btnAdd.Size = New System.Drawing.Size(96, 23)
    Me.btnAdd.TabIndex = 18
    Me.btnAdd.Text = "Dodaj"
    '
    'btnDelete
    '
    Me.btnDelete.ForeColor = System.Drawing.SystemColors.ControlText
    Me.btnDelete.Location = New System.Drawing.Point(168, 232)
    Me.btnDelete.Name = "btnDelete"
    Me.btnDelete.Size = New System.Drawing.Size(96, 23)
    Me.btnDelete.TabIndex = 19
    Me.btnDelete.Text = "Usu"
    '
    'btnCancel
    '
    Me.btnCancel.ForeColor = System.Drawing.Color.Maroon
    Me.btnCancel.Location = New System.Drawing.Point(264, 232)
    Me.btnCancel.Name = "btnCancel"
    Me.btnCancel.Size = New System.Drawing.Size(96, 23)
    Me.btnCancel.TabIndex = 20
    Me.btnCancel.Text = "Anuluj zmiany"
    '
    'Label1
    '
    Me.Label1.ForeColor = System.Drawing.Color.Maroon
    Me.Label1.Location = New System.Drawing.Point(96, 272)
    Me.Label1.Name = "Label1"
    Me.Label1.Size = New System.Drawing.Size(264, 48)
    Me.Label1.TabIndex = 21
    Me.Label1.Text = "Przyciski <Dodaj> oraz <Anuluj zmiany> s dodane w celu pokazania ograniczenia ty" & _
    "lko do odczytu kolekcji arraylist jako rda dla doaczania danych."
    '
    'MainMenu1
    '
    Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile, Me.mnuHelp})
    '
    'mnuFile
    '
    Me.mnuFile.Index = 0
    Me.mnuFile.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile_Exit})
    Me.mnuFile.Text = "&Plik"
    '
    'mnuFile_Exit
    '
    Me.mnuFile_Exit.Index = 0
    Me.mnuFile_Exit.Text = "&Koniec"
    '
    'mnuHelp
    '
    Me.mnuHelp.Index = 1
    Me.mnuHelp.Text = "P&omoc"
    '
    'frmMain
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(456, 522)
    Me.Controls.Add(Me.Label1)
    Me.Controls.Add(Me.btnCancel)
    Me.Controls.Add(Me.btnAdd)
    Me.Controls.Add(Me.btnDelete)
    Me.Controls.Add(Me.grdProducts)
    Me.Controls.Add(Me.chkDiscontinued)
    Me.Controls.Add(Me.lblDataGridView)
    Me.Controls.Add(Me.grpLoadRecords)
    Me.Controls.Add(Me.btnNavFirst)
    Me.Controls.Add(Me.btnNavPrev)
    Me.Controls.Add(Me.lblNavLocation)
    Me.Controls.Add(Me.btnNavNext)
    Me.Controls.Add(Me.btnNavLast)
    Me.Controls.Add(Me.lblReorderLevel)
    Me.Controls.Add(Me.lblQtyOnOrder)
    Me.Controls.Add(Me.lblQtyOnHand)
    Me.Controls.Add(Me.lblProduct)
    Me.Controls.Add(Me.txtReorderLevel)
    Me.Controls.Add(Me.txtQtyOnOrder)
    Me.Controls.Add(Me.txtQtyOnHand)
    Me.Controls.Add(Me.txtProductName)
    Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D
    Me.Menu = Me.MainMenu1
    Me.Name = "frmMain"
    Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
    Me.Text = "Doaczanie do listy obiektw"
    Me.grpLoadRecords.ResumeLayout(False)
    CType(Me.nudMinimumReorderLevel, System.ComponentModel.ISupportInitialize).EndInit()
    CType(Me.grdProducts, System.ComponentModel.ISupportInitialize).EndInit()
    Me.ResumeLayout(False)

  End Sub

#End Region

  Private Sub frmMain_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
    'We'll need an instantiated object based on the dsNw
    'dataset class in order to establish our data bindings.
    'm_dsData = New dsNw
  End Sub

  Private Sub btnNavFirst_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNavFirst.Click
    Me.BindingContext(m_arlProducts).Position = 0
    UpdateRecordPositionDisplay()
  End Sub

  Private Sub btnNavLast_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNavLast.Click
    Me.BindingContext(m_arlProducts).Position = Me.BindingContext(m_arlProducts).Count - 1
    UpdateRecordPositionDisplay()
  End Sub

  Private Sub btnNavPrev_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNavPrev.Click
    Me.BindingContext(m_arlProducts).Position = Me.BindingContext(m_arlProducts).Position - 1
    UpdateRecordPositionDisplay()
  End Sub

  Private Sub btnNavNext_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNavNext.Click
    Me.BindingContext(m_arlProducts).Position = Me.BindingContext(m_arlProducts).Position + 1
    UpdateRecordPositionDisplay()
  End Sub

  Private Sub UpdateRecordPositionDisplay()
    Dim strRecordCount As String
    Dim strRecordPosition As String
    strRecordCount = CType(Me.BindingContext(m_arlProducts).Count, String)
    strRecordPosition = Me.BindingContext(m_arlProducts).Position + 1
    Me.lblNavLocation.Text = "Rekord " & strRecordPosition & " z  " & strRecordCount
  End Sub

  Private Sub ClearBindings()
    Me.txtProductName.DataBindings.Clear()
    Me.txtQtyOnHand.DataBindings.Clear()
    Me.txtQtyOnOrder.DataBindings.Clear()
    Me.txtReorderLevel.DataBindings.Clear()
    Me.chkDiscontinued.DataBindings.Clear()
  End Sub


  Private Sub SetBindings()

    Me.txtProductName.DataBindings.Add( _
        New Binding("Text", m_arlProducts, "ProductName"))

    Me.txtQtyOnHand.DataBindings.Add( _
        New Binding("Text", m_arlProducts, "UnitsInStock"))

    Me.txtQtyOnOrder.DataBindings.Add( _
        New Binding("Text", m_arlProducts, "UnitsOnOrder"))

    Me.txtReorderLevel.DataBindings.Add( _
        New Binding("Text", m_arlProducts, "ReorderLevel"))

    Me.grdProducts.DataSource = m_arlProducts

  End Sub

  Private Sub btnRetrieveRecords_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRetrieveRecords.Click
    m_objData = New Data

    'We set our bindings in the form's load event to m_dsData.
    'If we now point m_dsData at a new DataSet, we will 
    'have to clear and reset 'those bindings.

    Try
      Dim intMinLevel As Int32 = CType(Me.nudMinimumReorderLevel.Text, Int32)
      m_arlProducts = m_objData.GetProducts(intMinLevel)
    Catch ex As Exception
      MessageBox.Show(ex.Message)
    End Try
    ClearBindings()
    SetBindings()
    UpdateRecordPositionDisplay()
    'AddHandler Me.BindingContext(Me.m_arlProducts).CurrentChanged, AddressOf OnCurrentObjectChanged

  End Sub

  Private Sub OnCurrentObjectChanged(ByVal Sender As Object, ByVal e As EventArgs)
    MessageBox.Show("Here in OnCurrentObjectChanged")
  End Sub

  Private Sub grdProducts_CurrentCellChanged(ByVal sender As System.Object, ByVal e As System.EventArgs)
    'Make sure the record position display keeps up with 
    'position changes made in the DataGrid as well as by
    'means of the provided navigational buttons.
    UpdateRecordPositionDisplay()
  End Sub

  Private Sub btnAdd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAdd.Click

    Dim strMsg As String
    strMsg = "W prawidowej implementacji do zapisu i odczytu teraz wywoana zostaaby metoda AddNew() z  "
    strMsg += "obiektu CurrencyManager. Jednak poniewa ArrayList jest obiektem, ktry zapamituje nasze "
    strMsg += "obiekty Product nie implementujc IBindingList, metoda AddNew() nie jest obsugiwana. Zamiast  "
    strMsg += "tego zostanie po prostu wywoana metoda Add() z klasy ArrayList. Powoduje to, e nowy towar  "
    strMsg += "zostanie dodany do ArrayList, ale obiekt CurrencyManager nie wie jak z niego korzysta. Jeeli  "
    strMsg += "sprbujemy przej do nowo dodanego obiektu (ostatniego na licie), zauwaysz, e nie jest to moliwe."
    
    MessageBox.Show(strMsg)

    Try
      Me.BindingContext(Me.m_arlProducts).EndCurrentEdit()
      'The AddNew() method of the CurrencyManager isn't supported
      'Me.BindingContext(Me.m_arlProducts).AddNew()
      Dim objProduct As New Product
      m_arlProducts.Add(objProduct)
      Me.BindingContext(Me.m_arlProducts).Position = Me.BindingContext(Me.m_arlProducts).Count
    Catch eEndEdit As System.Exception
      System.Windows.Forms.MessageBox.Show(eEndEdit.Message)
    End Try
    Me.UpdateRecordPositionDisplay()

  End Sub

  Private Sub btnDelete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDelete.Click

    'From the MSDN help file:
    'The RemoveAt method relies on the underlying data source to determine how the 
    'method behaves. (See the Binding class for a list of supported data sources). 
    'For classes that implement IList, IBindingList, ITypedList, as well as strongly typed 
    'classes that implement IList, the RemoveAt method actually deletes the row in the 
    'underlying list instead of removing it.

    Dim intPosition As Int32
    If m_arlProducts.Count = 0 Then Return 'Nothing to delete!

    'Problems occur when you delete the first or last item in the list while it is the
    'current record.  Also, screen refresh seems to be a little buggy unless you move
    'well away from the item you want to remove before removing it.  After a fair
    'amount of trial and error (sigh), I arrived at the following algorithm, which works
    'regardless of whether the current record is at the beginning, end, or in the middle
    'of the list.
    intPosition = Me.BindingContext(m_arlProducts).Position
    Select Case intPosition
      Case m_arlProducts.Count - 1
        'At end of collection.  
        Me.BindingContext(m_arlProducts).Position = 0
        m_arlProducts.RemoveAt(intPosition)
        Me.BindingContext(m_arlProducts).Position = intPosition - 1
      Case 0
        'At beginning of collection.
        Me.BindingContext(m_arlProducts).Position = m_arlProducts.Count - 2
        m_arlProducts.RemoveAt(intPosition)
        Me.BindingContext(m_arlProducts).Position = 0
      Case Else
        Me.BindingContext(m_arlProducts).Position = 0
        m_arlProducts.RemoveAt(intPosition)
        Me.BindingContext(m_arlProducts).Position = intPosition
    End Select

    Me.UpdateRecordPositionDisplay()

    Dim strMsg As String
    strMsg = "Delete functionality works because the arraylist implements IList, and therefore"
    strMsg += "its CurrencyManager supports RemoveAt()."
    MessageBox.Show(strMsg)

    'This delete functionality works, but note that in our DataTable implementation 
    'of this application (BindToADataTable), the code 'to handle a delete is much simpler:
    '
    'If (Me.BindingContext(m_arlProducts).Count > 0) Then
    '    Me.BindingContext(m_arlProducts).RemoveAt(Me.BindingContext(m_arlProducts).Position)
    '    Me.UpdateRecordPositionDisplay()
    'End If

  End Sub

  Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click

    Dim strMsg As String
    strMsg = "The CancelCurrentEdit() method invoked by this action is supported only "
    strMsg += "if the data source for the binding implements the IEditableObject interface. "
    strMsg += "In this application, the Product object is the data source, and it does NOT "
    strMsg += "implement IEditableObject.  Therefore invoking CancelCurrentEdit does "
    strMsg += "not result in changes being discarded."
    MessageBox.Show(strMsg)

    Me.BindingContext(m_arlProducts).CancelCurrentEdit()
    Me.UpdateRecordPositionDisplay()

  End Sub

  Private Sub mnuFile_Exit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuFile_Exit.Click
    Me.Close()
  End Sub

  Private Sub mnuHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuHelp.Click
    Dim frmX As New frmHelp("..\zzReadMe.txt")
    frmX.Show()
  End Sub
End Class
