Imports System.Data.SqlClient

Public Class frmMain
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents ToolTip1 As System.Windows.Forms.ToolTip
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
    Friend WithEvents mnuFile As System.Windows.Forms.MenuItem
    Friend WithEvents mnuFile_Exit As System.Windows.Forms.MenuItem
    Friend WithEvents mnuHelp As System.Windows.Forms.MenuItem
    Public WithEvents optIsolation2Serializable As System.Windows.Forms.RadioButton
    Public WithEvents optIsolation2RepeatableRead As System.Windows.Forms.RadioButton
    Public WithEvents optIsolation2ReadUncommitted As System.Windows.Forms.RadioButton
    Public WithEvents optIsolation2ReadCommitted As System.Windows.Forms.RadioButton
    Public WithEvents optIsolation1Serializable As System.Windows.Forms.RadioButton
    Public WithEvents optIsolation1RepeatableRead As System.Windows.Forms.RadioButton
    Public WithEvents optIsolation1ReadUncommitted As System.Windows.Forms.RadioButton
    Public WithEvents optIsolation1ReadCommitted As System.Windows.Forms.RadioButton
    Friend WithEvents grdProcess1Data As System.Windows.Forms.DataGrid
    Friend WithEvents grpTransaction1 As System.Windows.Forms.GroupBox
    Friend WithEvents btnProcess2Begin As System.Windows.Forms.Button
    Friend WithEvents grpProcess2IsolationLevel As System.Windows.Forms.GroupBox
    Friend WithEvents grpProcess1IsolationLevel As System.Windows.Forms.GroupBox
    Friend WithEvents btnProcess1Begin As System.Windows.Forms.Button
    Friend WithEvents grdProcess2Data As System.Windows.Forms.DataGrid
    Friend WithEvents grpTransaction2 As System.Windows.Forms.GroupBox
    Friend WithEvents grpProcess1SelectOperation As System.Windows.Forms.GroupBox
    Friend WithEvents grpProcess2SelectOperation As System.Windows.Forms.GroupBox
    Friend WithEvents btnProcess1RollBack As System.Windows.Forms.Button
    Friend WithEvents btnProcess2RollBack As System.Windows.Forms.Button
    Friend WithEvents btnProcess1Commit As System.Windows.Forms.Button
    Friend WithEvents btnProcess2Commit As System.Windows.Forms.Button
    Friend WithEvents optOperationEdit1 As System.Windows.Forms.RadioButton
    Friend WithEvents optOperationAdd1 As System.Windows.Forms.RadioButton
    Friend WithEvents optOperationDelete1 As System.Windows.Forms.RadioButton
    Friend WithEvents optOperationRead1 As System.Windows.Forms.RadioButton
    Friend WithEvents optOperationRead2 As System.Windows.Forms.RadioButton
    Friend WithEvents optOperationEdit2 As System.Windows.Forms.RadioButton
    Friend WithEvents optOperationAdd2 As System.Windows.Forms.RadioButton
    Friend WithEvents optOperationDelete2 As System.Windows.Forms.RadioButton
    Friend WithEvents chkProcess1UpdateBackEnd As System.Windows.Forms.CheckBox
    Friend WithEvents grpProcess2OperatingConditions As System.Windows.Forms.GroupBox
    Friend WithEvents grpProcess1OperatingConditions As System.Windows.Forms.GroupBox
    Friend WithEvents chkProcess2UpdateBackEnd As System.Windows.Forms.CheckBox
    Friend WithEvents chkProcess1WrapInTransaction As System.Windows.Forms.CheckBox
    Friend WithEvents chkProcess2WrapInTransaction As System.Windows.Forms.CheckBox
    Friend WithEvents btnClearGrid1 As System.Windows.Forms.Button
    Friend WithEvents btnClearGrid2 As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.components = New System.ComponentModel.Container
    Me.grdProcess1Data = New System.Windows.Forms.DataGrid
    Me.chkProcess1UpdateBackEnd = New System.Windows.Forms.CheckBox
    Me.chkProcess1WrapInTransaction = New System.Windows.Forms.CheckBox
    Me.grpTransaction1 = New System.Windows.Forms.GroupBox
    Me.btnClearGrid1 = New System.Windows.Forms.Button
    Me.btnProcess1Commit = New System.Windows.Forms.Button
    Me.btnProcess1RollBack = New System.Windows.Forms.Button
    Me.grpProcess1SelectOperation = New System.Windows.Forms.GroupBox
    Me.optOperationEdit1 = New System.Windows.Forms.RadioButton
    Me.optOperationAdd1 = New System.Windows.Forms.RadioButton
    Me.optOperationDelete1 = New System.Windows.Forms.RadioButton
    Me.optOperationRead1 = New System.Windows.Forms.RadioButton
    Me.grpProcess1OperatingConditions = New System.Windows.Forms.GroupBox
    Me.grpProcess1IsolationLevel = New System.Windows.Forms.GroupBox
    Me.optIsolation1Serializable = New System.Windows.Forms.RadioButton
    Me.optIsolation1RepeatableRead = New System.Windows.Forms.RadioButton
    Me.optIsolation1ReadUncommitted = New System.Windows.Forms.RadioButton
    Me.optIsolation1ReadCommitted = New System.Windows.Forms.RadioButton
    Me.btnProcess1Begin = New System.Windows.Forms.Button
    Me.btnProcess2Begin = New System.Windows.Forms.Button
    Me.grpProcess2IsolationLevel = New System.Windows.Forms.GroupBox
    Me.optIsolation2Serializable = New System.Windows.Forms.RadioButton
    Me.optIsolation2RepeatableRead = New System.Windows.Forms.RadioButton
    Me.optIsolation2ReadUncommitted = New System.Windows.Forms.RadioButton
    Me.optIsolation2ReadCommitted = New System.Windows.Forms.RadioButton
    Me.grdProcess2Data = New System.Windows.Forms.DataGrid
    Me.ToolTip1 = New System.Windows.Forms.ToolTip(Me.components)
    Me.MainMenu1 = New System.Windows.Forms.MainMenu
    Me.mnuFile = New System.Windows.Forms.MenuItem
    Me.mnuFile_Exit = New System.Windows.Forms.MenuItem
    Me.mnuHelp = New System.Windows.Forms.MenuItem
    Me.grpTransaction2 = New System.Windows.Forms.GroupBox
    Me.grpProcess2SelectOperation = New System.Windows.Forms.GroupBox
    Me.optOperationRead2 = New System.Windows.Forms.RadioButton
    Me.optOperationEdit2 = New System.Windows.Forms.RadioButton
    Me.optOperationAdd2 = New System.Windows.Forms.RadioButton
    Me.optOperationDelete2 = New System.Windows.Forms.RadioButton
    Me.grpProcess2OperatingConditions = New System.Windows.Forms.GroupBox
    Me.chkProcess2UpdateBackEnd = New System.Windows.Forms.CheckBox
    Me.chkProcess2WrapInTransaction = New System.Windows.Forms.CheckBox
    Me.btnProcess2RollBack = New System.Windows.Forms.Button
    Me.btnProcess2Commit = New System.Windows.Forms.Button
    Me.btnClearGrid2 = New System.Windows.Forms.Button
    CType(Me.grdProcess1Data, System.ComponentModel.ISupportInitialize).BeginInit()
    Me.grpTransaction1.SuspendLayout()
    Me.grpProcess1SelectOperation.SuspendLayout()
    Me.grpProcess1OperatingConditions.SuspendLayout()
    Me.grpProcess1IsolationLevel.SuspendLayout()
    Me.grpProcess2IsolationLevel.SuspendLayout()
    CType(Me.grdProcess2Data, System.ComponentModel.ISupportInitialize).BeginInit()
    Me.grpTransaction2.SuspendLayout()
    Me.grpProcess2SelectOperation.SuspendLayout()
    Me.grpProcess2OperatingConditions.SuspendLayout()
    Me.SuspendLayout()
    '
    'grdProcess1Data
    '
    Me.grdProcess1Data.DataMember = ""
    Me.grdProcess1Data.HeaderForeColor = System.Drawing.SystemColors.ControlText
    Me.grdProcess1Data.Location = New System.Drawing.Point(16, 344)
    Me.grdProcess1Data.Name = "grdProcess1Data"
    Me.grdProcess1Data.Size = New System.Drawing.Size(328, 168)
    Me.grdProcess1Data.TabIndex = 4
    '
    'chkProcess1UpdateBackEnd
    '
    Me.chkProcess1UpdateBackEnd.Checked = True
    Me.chkProcess1UpdateBackEnd.CheckState = System.Windows.Forms.CheckState.Checked
    Me.chkProcess1UpdateBackEnd.Location = New System.Drawing.Point(16, 48)
    Me.chkProcess1UpdateBackEnd.Name = "chkProcess1UpdateBackEnd"
    Me.chkProcess1UpdateBackEnd.Size = New System.Drawing.Size(296, 24)
    Me.chkProcess1UpdateBackEnd.TabIndex = 0
    Me.chkProcess1UpdateBackEnd.Text = "Przelij zmiany w DataSet do bazy danych"
    '
    'chkProcess1WrapInTransaction
    '
    Me.chkProcess1WrapInTransaction.Checked = True
    Me.chkProcess1WrapInTransaction.CheckState = System.Windows.Forms.CheckState.Checked
    Me.chkProcess1WrapInTransaction.Location = New System.Drawing.Point(16, 24)
    Me.chkProcess1WrapInTransaction.Name = "chkProcess1WrapInTransaction"
    Me.chkProcess1WrapInTransaction.Size = New System.Drawing.Size(296, 24)
    Me.chkProcess1WrapInTransaction.TabIndex = 1
    Me.chkProcess1WrapInTransaction.Text = "Wykonaj operacj w transakcji"
    '
    'grpTransaction1
    '
    Me.grpTransaction1.Controls.Add(Me.btnClearGrid1)
    Me.grpTransaction1.Controls.Add(Me.btnProcess1Commit)
    Me.grpTransaction1.Controls.Add(Me.btnProcess1RollBack)
    Me.grpTransaction1.Controls.Add(Me.grpProcess1SelectOperation)
    Me.grpTransaction1.Controls.Add(Me.grpProcess1OperatingConditions)
    Me.grpTransaction1.Controls.Add(Me.grpProcess1IsolationLevel)
    Me.grpTransaction1.Controls.Add(Me.grdProcess1Data)
    Me.grpTransaction1.Controls.Add(Me.btnProcess1Begin)
    Me.grpTransaction1.Location = New System.Drawing.Point(24, 8)
    Me.grpTransaction1.Name = "grpTransaction1"
    Me.grpTransaction1.Size = New System.Drawing.Size(360, 552)
    Me.grpTransaction1.TabIndex = 0
    Me.grpTransaction1.TabStop = False
    Me.grpTransaction1.Text = "Proces 1"
    '
    'btnClearGrid1
    '
    Me.btnClearGrid1.ForeColor = System.Drawing.SystemColors.ControlText
    Me.btnClearGrid1.Location = New System.Drawing.Point(280, 520)
    Me.btnClearGrid1.Name = "btnClearGrid1"
    Me.btnClearGrid1.Size = New System.Drawing.Size(64, 23)
    Me.btnClearGrid1.TabIndex = 7
    Me.btnClearGrid1.Text = "Czy"
    '
    'btnProcess1Commit
    '
    Me.btnProcess1Commit.ForeColor = System.Drawing.Color.FromArgb(CType(192, Byte), CType(0, Byte), CType(0, Byte))
    Me.btnProcess1Commit.Location = New System.Drawing.Point(152, 520)
    Me.btnProcess1Commit.Name = "btnProcess1Commit"
    Me.btnProcess1Commit.Size = New System.Drawing.Size(120, 23)
    Me.btnProcess1Commit.TabIndex = 6
    Me.btnProcess1Commit.Text = "Zatwierd transakcj"
    '
    'btnProcess1RollBack
    '
    Me.btnProcess1RollBack.ForeColor = System.Drawing.Color.FromArgb(CType(192, Byte), CType(0, Byte), CType(0, Byte))
    Me.btnProcess1RollBack.Location = New System.Drawing.Point(16, 520)
    Me.btnProcess1RollBack.Name = "btnProcess1RollBack"
    Me.btnProcess1RollBack.Size = New System.Drawing.Size(128, 23)
    Me.btnProcess1RollBack.TabIndex = 5
    Me.btnProcess1RollBack.Text = "Wycofaj transakcj"
    '
    'grpProcess1SelectOperation
    '
    Me.grpProcess1SelectOperation.Controls.Add(Me.optOperationEdit1)
    Me.grpProcess1SelectOperation.Controls.Add(Me.optOperationAdd1)
    Me.grpProcess1SelectOperation.Controls.Add(Me.optOperationDelete1)
    Me.grpProcess1SelectOperation.Controls.Add(Me.optOperationRead1)
    Me.grpProcess1SelectOperation.Location = New System.Drawing.Point(16, 24)
    Me.grpProcess1SelectOperation.Name = "grpProcess1SelectOperation"
    Me.grpProcess1SelectOperation.Size = New System.Drawing.Size(328, 80)
    Me.grpProcess1SelectOperation.TabIndex = 0
    Me.grpProcess1SelectOperation.TabStop = False
    Me.grpProcess1SelectOperation.Text = "Wybierz operacj wykonywan na lokalnym obiekcie DataSet"
    '
    'optOperationEdit1
    '
    Me.optOperationEdit1.Location = New System.Drawing.Point(16, 48)
    Me.optOperationEdit1.Name = "optOperationEdit1"
    Me.optOperationEdit1.Size = New System.Drawing.Size(128, 24)
    Me.optOperationEdit1.TabIndex = 2
    Me.optOperationEdit1.Text = "Edycja biecego rekordu"
    '
    'optOperationAdd1
    '
    Me.optOperationAdd1.Location = New System.Drawing.Point(168, 16)
    Me.optOperationAdd1.Name = "optOperationAdd1"
    Me.optOperationAdd1.Size = New System.Drawing.Size(112, 24)
    Me.optOperationAdd1.TabIndex = 1
    Me.optOperationAdd1.Text = "Dodanie rekordu"
    '
    'optOperationDelete1
    '
    Me.optOperationDelete1.Location = New System.Drawing.Point(168, 48)
    Me.optOperationDelete1.Name = "optOperationDelete1"
    Me.optOperationDelete1.Size = New System.Drawing.Size(136, 24)
    Me.optOperationDelete1.TabIndex = 3
    Me.optOperationDelete1.Text = "Kasowanie biecego rekordu"
    '
    'optOperationRead1
    '
    Me.optOperationRead1.Checked = True
    Me.optOperationRead1.Location = New System.Drawing.Point(16, 16)
    Me.optOperationRead1.Name = "optOperationRead1"
    Me.optOperationRead1.Size = New System.Drawing.Size(128, 24)
    Me.optOperationRead1.TabIndex = 0
    Me.optOperationRead1.TabStop = True
    Me.optOperationRead1.Text = "Odczyt rekordw"
    '
    'grpProcess1OperatingConditions
    '
    Me.grpProcess1OperatingConditions.Controls.Add(Me.chkProcess1UpdateBackEnd)
    Me.grpProcess1OperatingConditions.Controls.Add(Me.chkProcess1WrapInTransaction)
    Me.grpProcess1OperatingConditions.Location = New System.Drawing.Point(16, 120)
    Me.grpProcess1OperatingConditions.Name = "grpProcess1OperatingConditions"
    Me.grpProcess1OperatingConditions.Size = New System.Drawing.Size(328, 80)
    Me.grpProcess1OperatingConditions.TabIndex = 1
    Me.grpProcess1OperatingConditions.TabStop = False
    Me.grpProcess1OperatingConditions.Text = "Wybierz warunki wykonania"
    '
    'grpProcess1IsolationLevel
    '
    Me.grpProcess1IsolationLevel.Controls.Add(Me.optIsolation1Serializable)
    Me.grpProcess1IsolationLevel.Controls.Add(Me.optIsolation1RepeatableRead)
    Me.grpProcess1IsolationLevel.Controls.Add(Me.optIsolation1ReadUncommitted)
    Me.grpProcess1IsolationLevel.Controls.Add(Me.optIsolation1ReadCommitted)
    Me.grpProcess1IsolationLevel.Enabled = False
    Me.grpProcess1IsolationLevel.Location = New System.Drawing.Point(16, 216)
    Me.grpProcess1IsolationLevel.Name = "grpProcess1IsolationLevel"
    Me.grpProcess1IsolationLevel.Size = New System.Drawing.Size(328, 80)
    Me.grpProcess1IsolationLevel.TabIndex = 2
    Me.grpProcess1IsolationLevel.TabStop = False
    Me.grpProcess1IsolationLevel.Text = "Ustaw IsolationLevel dla transakcji"
    '
    'optIsolation1Serializable
    '
    Me.optIsolation1Serializable.Location = New System.Drawing.Point(192, 48)
    Me.optIsolation1Serializable.Name = "optIsolation1Serializable"
    Me.optIsolation1Serializable.Size = New System.Drawing.Size(120, 24)
    Me.optIsolation1Serializable.TabIndex = 3
    Me.optIsolation1Serializable.Text = "Serializable"
    '
    'optIsolation1RepeatableRead
    '
    Me.optIsolation1RepeatableRead.Location = New System.Drawing.Point(16, 48)
    Me.optIsolation1RepeatableRead.Name = "optIsolation1RepeatableRead"
    Me.optIsolation1RepeatableRead.Size = New System.Drawing.Size(112, 24)
    Me.optIsolation1RepeatableRead.TabIndex = 2
    Me.optIsolation1RepeatableRead.Text = "RepeatableRead"
    '
    'optIsolation1ReadUncommitted
    '
    Me.optIsolation1ReadUncommitted.Location = New System.Drawing.Point(192, 24)
    Me.optIsolation1ReadUncommitted.Name = "optIsolation1ReadUncommitted"
    Me.optIsolation1ReadUncommitted.Size = New System.Drawing.Size(120, 24)
    Me.optIsolation1ReadUncommitted.TabIndex = 1
    Me.optIsolation1ReadUncommitted.Text = "ReadUncommitted"
    '
    'optIsolation1ReadCommitted
    '
    Me.optIsolation1ReadCommitted.Checked = True
    Me.optIsolation1ReadCommitted.Location = New System.Drawing.Point(16, 24)
    Me.optIsolation1ReadCommitted.Name = "optIsolation1ReadCommitted"
    Me.optIsolation1ReadCommitted.Size = New System.Drawing.Size(168, 24)
    Me.optIsolation1ReadCommitted.TabIndex = 0
    Me.optIsolation1ReadCommitted.TabStop = True
    Me.optIsolation1ReadCommitted.Text = "ReadCommitted (domylny)"
    '
    'btnProcess1Begin
    '
    Me.btnProcess1Begin.Location = New System.Drawing.Point(16, 312)
    Me.btnProcess1Begin.Name = "btnProcess1Begin"
    Me.btnProcess1Begin.Size = New System.Drawing.Size(328, 24)
    Me.btnProcess1Begin.TabIndex = 3
    Me.btnProcess1Begin.Text = "Wykonaj wybran operacj"
    '
    'btnProcess2Begin
    '
    Me.btnProcess2Begin.Location = New System.Drawing.Point(16, 312)
    Me.btnProcess2Begin.Name = "btnProcess2Begin"
    Me.btnProcess2Begin.Size = New System.Drawing.Size(328, 24)
    Me.btnProcess2Begin.TabIndex = 3
    Me.btnProcess2Begin.Text = "Wykonaj wybran operacj"
    Me.ToolTip1.SetToolTip(Me.btnProcess2Begin, "Zmienia warto kolumny 'Discontinued' wybranego rekordu w tabeli Products")
    '
    'grpProcess2IsolationLevel
    '
    Me.grpProcess2IsolationLevel.Controls.Add(Me.optIsolation2Serializable)
    Me.grpProcess2IsolationLevel.Controls.Add(Me.optIsolation2RepeatableRead)
    Me.grpProcess2IsolationLevel.Controls.Add(Me.optIsolation2ReadUncommitted)
    Me.grpProcess2IsolationLevel.Controls.Add(Me.optIsolation2ReadCommitted)
    Me.grpProcess2IsolationLevel.Enabled = False
    Me.grpProcess2IsolationLevel.Location = New System.Drawing.Point(16, 216)
    Me.grpProcess2IsolationLevel.Name = "grpProcess2IsolationLevel"
    Me.grpProcess2IsolationLevel.Size = New System.Drawing.Size(328, 80)
    Me.grpProcess2IsolationLevel.TabIndex = 2
    Me.grpProcess2IsolationLevel.TabStop = False
    Me.grpProcess2IsolationLevel.Text = "Ustaw IsolationLevel dla transakcji"
    '
    'optIsolation2Serializable
    '
    Me.optIsolation2Serializable.Location = New System.Drawing.Point(184, 48)
    Me.optIsolation2Serializable.Name = "optIsolation2Serializable"
    Me.optIsolation2Serializable.Size = New System.Drawing.Size(128, 24)
    Me.optIsolation2Serializable.TabIndex = 3
    Me.optIsolation2Serializable.Text = "Serializable"
    '
    'optIsolation2RepeatableRead
    '
    Me.optIsolation2RepeatableRead.Location = New System.Drawing.Point(16, 48)
    Me.optIsolation2RepeatableRead.Name = "optIsolation2RepeatableRead"
    Me.optIsolation2RepeatableRead.Size = New System.Drawing.Size(112, 24)
    Me.optIsolation2RepeatableRead.TabIndex = 2
    Me.optIsolation2RepeatableRead.Text = "RepeatableRead"
    '
    'optIsolation2ReadUncommitted
    '
    Me.optIsolation2ReadUncommitted.Checked = True
    Me.optIsolation2ReadUncommitted.Location = New System.Drawing.Point(184, 24)
    Me.optIsolation2ReadUncommitted.Name = "optIsolation2ReadUncommitted"
    Me.optIsolation2ReadUncommitted.Size = New System.Drawing.Size(128, 24)
    Me.optIsolation2ReadUncommitted.TabIndex = 1
    Me.optIsolation2ReadUncommitted.TabStop = True
    Me.optIsolation2ReadUncommitted.Text = "ReadUncommitted"
    '
    'optIsolation2ReadCommitted
    '
    Me.optIsolation2ReadCommitted.Location = New System.Drawing.Point(16, 24)
    Me.optIsolation2ReadCommitted.Name = "optIsolation2ReadCommitted"
    Me.optIsolation2ReadCommitted.Size = New System.Drawing.Size(184, 24)
    Me.optIsolation2ReadCommitted.TabIndex = 0
    Me.optIsolation2ReadCommitted.Text = "ReadCommitted (domylny)"
    '
    'grdProcess2Data
    '
    Me.grdProcess2Data.DataMember = ""
    Me.grdProcess2Data.HeaderForeColor = System.Drawing.SystemColors.ControlText
    Me.grdProcess2Data.Location = New System.Drawing.Point(16, 344)
    Me.grdProcess2Data.Name = "grdProcess2Data"
    Me.grdProcess2Data.Size = New System.Drawing.Size(328, 168)
    Me.grdProcess2Data.TabIndex = 4
    '
    'MainMenu1
    '
    Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile, Me.mnuHelp})
    '
    'mnuFile
    '
    Me.mnuFile.Index = 0
    Me.mnuFile.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile_Exit})
    Me.mnuFile.Text = "&Plik"
    '
    'mnuFile_Exit
    '
    Me.mnuFile_Exit.Index = 0
    Me.mnuFile_Exit.Text = "&Koniec"
    '
    'mnuHelp
    '
    Me.mnuHelp.Index = 1
    Me.mnuHelp.Text = "&Pomoc"
    '
    'grpTransaction2
    '
    Me.grpTransaction2.Controls.Add(Me.grpProcess2SelectOperation)
    Me.grpTransaction2.Controls.Add(Me.grpProcess2OperatingConditions)
    Me.grpTransaction2.Controls.Add(Me.grpProcess2IsolationLevel)
    Me.grpTransaction2.Controls.Add(Me.grdProcess2Data)
    Me.grpTransaction2.Controls.Add(Me.btnProcess2RollBack)
    Me.grpTransaction2.Controls.Add(Me.btnProcess2Begin)
    Me.grpTransaction2.Controls.Add(Me.btnProcess2Commit)
    Me.grpTransaction2.Controls.Add(Me.btnClearGrid2)
    Me.grpTransaction2.Location = New System.Drawing.Point(408, 8)
    Me.grpTransaction2.Name = "grpTransaction2"
    Me.grpTransaction2.Size = New System.Drawing.Size(360, 552)
    Me.grpTransaction2.TabIndex = 1
    Me.grpTransaction2.TabStop = False
    Me.grpTransaction2.Text = "Proces 2"
    '
    'grpProcess2SelectOperation
    '
    Me.grpProcess2SelectOperation.Controls.Add(Me.optOperationRead2)
    Me.grpProcess2SelectOperation.Controls.Add(Me.optOperationEdit2)
    Me.grpProcess2SelectOperation.Controls.Add(Me.optOperationAdd2)
    Me.grpProcess2SelectOperation.Controls.Add(Me.optOperationDelete2)
    Me.grpProcess2SelectOperation.Location = New System.Drawing.Point(16, 24)
    Me.grpProcess2SelectOperation.Name = "grpProcess2SelectOperation"
    Me.grpProcess2SelectOperation.Size = New System.Drawing.Size(328, 80)
    Me.grpProcess2SelectOperation.TabIndex = 0
    Me.grpProcess2SelectOperation.TabStop = False
    Me.grpProcess2SelectOperation.Text = "Wybierz wykonywan operacj"
    '
    'optOperationRead2
    '
    Me.optOperationRead2.Checked = True
    Me.optOperationRead2.Location = New System.Drawing.Point(16, 24)
    Me.optOperationRead2.Name = "optOperationRead2"
    Me.optOperationRead2.Size = New System.Drawing.Size(128, 24)
    Me.optOperationRead2.TabIndex = 0
    Me.optOperationRead2.TabStop = True
    Me.optOperationRead2.Text = "Odczyt rekordw"
    '
    'optOperationEdit2
    '
    Me.optOperationEdit2.Location = New System.Drawing.Point(16, 48)
    Me.optOperationEdit2.Name = "optOperationEdit2"
    Me.optOperationEdit2.Size = New System.Drawing.Size(136, 24)
    Me.optOperationEdit2.TabIndex = 2
    Me.optOperationEdit2.Text = "Edycja biecego rekordu"
    '
    'optOperationAdd2
    '
    Me.optOperationAdd2.Location = New System.Drawing.Point(168, 24)
    Me.optOperationAdd2.Name = "optOperationAdd2"
    Me.optOperationAdd2.Size = New System.Drawing.Size(152, 24)
    Me.optOperationAdd2.TabIndex = 1
    Me.optOperationAdd2.Text = "Dodanie rekordu"
    '
    'optOperationDelete2
    '
    Me.optOperationDelete2.Location = New System.Drawing.Point(168, 48)
    Me.optOperationDelete2.Name = "optOperationDelete2"
    Me.optOperationDelete2.Size = New System.Drawing.Size(152, 24)
    Me.optOperationDelete2.TabIndex = 3
    Me.optOperationDelete2.Text = "Kasowanie biecego rekordu"
    '
    'grpProcess2OperatingConditions
    '
    Me.grpProcess2OperatingConditions.Controls.Add(Me.chkProcess2UpdateBackEnd)
    Me.grpProcess2OperatingConditions.Controls.Add(Me.chkProcess2WrapInTransaction)
    Me.grpProcess2OperatingConditions.Location = New System.Drawing.Point(16, 120)
    Me.grpProcess2OperatingConditions.Name = "grpProcess2OperatingConditions"
    Me.grpProcess2OperatingConditions.Size = New System.Drawing.Size(328, 80)
    Me.grpProcess2OperatingConditions.TabIndex = 1
    Me.grpProcess2OperatingConditions.TabStop = False
    Me.grpProcess2OperatingConditions.Text = "Wybierz warunki wykonania"
    '
    'chkProcess2UpdateBackEnd
    '
    Me.chkProcess2UpdateBackEnd.Checked = True
    Me.chkProcess2UpdateBackEnd.CheckState = System.Windows.Forms.CheckState.Checked
    Me.chkProcess2UpdateBackEnd.Location = New System.Drawing.Point(16, 48)
    Me.chkProcess2UpdateBackEnd.Name = "chkProcess2UpdateBackEnd"
    Me.chkProcess2UpdateBackEnd.Size = New System.Drawing.Size(296, 24)
    Me.chkProcess2UpdateBackEnd.TabIndex = 2
    Me.chkProcess2UpdateBackEnd.Text = "Przelij zmiany w DataSet do bazy danych"
    '
    'chkProcess2WrapInTransaction
    '
    Me.chkProcess2WrapInTransaction.Checked = True
    Me.chkProcess2WrapInTransaction.CheckState = System.Windows.Forms.CheckState.Checked
    Me.chkProcess2WrapInTransaction.Location = New System.Drawing.Point(16, 24)
    Me.chkProcess2WrapInTransaction.Name = "chkProcess2WrapInTransaction"
    Me.chkProcess2WrapInTransaction.Size = New System.Drawing.Size(296, 24)
    Me.chkProcess2WrapInTransaction.TabIndex = 3
    Me.chkProcess2WrapInTransaction.Text = "Wykonaj operacj w transakcji"
    '
    'btnProcess2RollBack
    '
    Me.btnProcess2RollBack.ForeColor = System.Drawing.Color.FromArgb(CType(192, Byte), CType(0, Byte), CType(0, Byte))
    Me.btnProcess2RollBack.Location = New System.Drawing.Point(16, 520)
    Me.btnProcess2RollBack.Name = "btnProcess2RollBack"
    Me.btnProcess2RollBack.Size = New System.Drawing.Size(128, 23)
    Me.btnProcess2RollBack.TabIndex = 5
    Me.btnProcess2RollBack.Text = "Wycofaj transakcj"
    '
    'btnProcess2Commit
    '
    Me.btnProcess2Commit.ForeColor = System.Drawing.Color.FromArgb(CType(192, Byte), CType(0, Byte), CType(0, Byte))
    Me.btnProcess2Commit.Location = New System.Drawing.Point(152, 520)
    Me.btnProcess2Commit.Name = "btnProcess2Commit"
    Me.btnProcess2Commit.Size = New System.Drawing.Size(120, 23)
    Me.btnProcess2Commit.TabIndex = 6
    Me.btnProcess2Commit.Text = "Zatwierd transakcj"
    '
    'btnClearGrid2
    '
    Me.btnClearGrid2.ForeColor = System.Drawing.SystemColors.ControlText
    Me.btnClearGrid2.Location = New System.Drawing.Point(280, 520)
    Me.btnClearGrid2.Name = "btnClearGrid2"
    Me.btnClearGrid2.Size = New System.Drawing.Size(64, 23)
    Me.btnClearGrid2.TabIndex = 8
    Me.btnClearGrid2.Text = "Czy"
    '
    'frmMain
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(790, 571)
    Me.Controls.Add(Me.grpTransaction1)
    Me.Controls.Add(Me.grpTransaction2)
    Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D
    Me.Menu = Me.MainMenu1
    Me.Name = "frmMain"
    Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
    Me.Text = "Przegld interakcji transakcji"
    CType(Me.grdProcess1Data, System.ComponentModel.ISupportInitialize).EndInit()
    Me.grpTransaction1.ResumeLayout(False)
    Me.grpProcess1SelectOperation.ResumeLayout(False)
    Me.grpProcess1OperatingConditions.ResumeLayout(False)
    Me.grpProcess1IsolationLevel.ResumeLayout(False)
    Me.grpProcess2IsolationLevel.ResumeLayout(False)
    CType(Me.grdProcess2Data, System.ComponentModel.ISupportInitialize).EndInit()
    Me.grpTransaction2.ResumeLayout(False)
    Me.grpProcess2SelectOperation.ResumeLayout(False)
    Me.grpProcess2OperatingConditions.ResumeLayout(False)
    Me.ResumeLayout(False)

  End Sub

#End Region

    Const kCommandTimeout As Int32 = 2

    Dim trans1 As SqlTransaction
    Dim trans2 As SqlTransaction
    Dim WithEvents objdsNw1 As TransactionInteractionExplorer.dsNw
    Dim WithEvents objdsNw2 As TransactionInteractionExplorer.dsNw
    Dim conNw1 As SqlConnection
    Dim conNw2 As SqlConnection
    Friend WithEvents daProducts As SqlDataAdapter
    Friend WithEvents cmdProductsSelect As SqlCommand
    Friend WithEvents cmdProductsInsert As SqlCommand
    Friend WithEvents cmdProductsUpdate As SqlCommand
    Friend WithEvents cmdProductsDelete As SqlCommand

    Private Enum enmTransaction
        Transaction1
        Transaction2
    End Enum

    Private Enum enmDispositionTechnique
        Commit
        RollBack
        CloseConnection
    End Enum

    Private Enum enmOperationToPerform
        ReadRecords
        AddRecord
        EditCurrentRecord
        DeleteCurrentRecord
    End Enum

    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        InitializeDataMachinery()
        SetStateOfGrpIsolationLevel(enmTransaction.Transaction1)
        SetStateOfGrpIsolationLevel(enmTransaction.Transaction2)
        EnableTransactionStartStopButtons(enmTransaction.Transaction1, False)
        EnableTransactionStartStopButtons(enmTransaction.Transaction2, False)
    End Sub

    Private Sub btnProcess1Begin_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnProcess1Begin.Click
        PerformIndicationOperations(enmTransaction.Transaction1)
    End Sub

    Private Sub btnProcess2Begin_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnProcess2Begin.Click
        PerformIndicationOperations(enmTransaction.Transaction2)
    End Sub

    Private Sub btnProcess1RollBack_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnProcess1RollBack.Click
        RollbackTrans(trans1)
        SetPostTransactionState(enmTransaction.Transaction1)
    End Sub

    Private Sub btnClearGrid1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClearGrid1.Click
        If Me.grdProcess1Data.DataSource Is Nothing Then
            MessageBox.Show("DataGrid for Process #1 is already empty.")
        Else
            Me.grdProcess1Data.DataSource = Nothing
        End If
    End Sub

    Private Sub btnClearGrid2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClearGrid2.Click
        If Me.grdProcess2Data.DataSource Is Nothing Then
            MessageBox.Show("DataGrid for Process #2 is already empty.")
        Else
            Me.grdProcess2Data.DataSource = Nothing
        End If
    End Sub

    Private Sub SetPostTransactionState(ByVal penmTrans As enmTransaction)
        Select Case penmTrans
            Case enmTransaction.Transaction1
                conNw1.Close()
                Me.optOperationRead1.Checked = True
            Case enmTransaction.Transaction2
                conNw2.Close()
                Me.optOperationRead2.Checked = True
        End Select
        EnableTransactionStartStopButtons(penmTrans, False)
    End Sub

    Private Sub btnProcess2RollBack_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnProcess2RollBack.Click
        RollbackTrans(trans2)
        SetPostTransactionState(enmTransaction.Transaction2)
    End Sub

    Private Sub btnProcess1Commit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnProcess1Commit.Click
        CommitTrans(trans1)
        SetPostTransactionState(enmTransaction.Transaction1)
    End Sub

    Private Sub btnProcess2Commit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnProcess2Commit.Click
        CommitTrans(trans2)
        SetPostTransactionState(enmTransaction.Transaction2)
    End Sub

    Private Sub mnuFile_Exit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuFile_Exit.Click
        Me.Close()
    End Sub

    Private Sub mnuHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuHelp.Click
        Dim frmX As New frmHelp("..\zzReadMe.txt")
        frmX.Show()
    End Sub

    Private Sub chkProcess1WrapInTransaction_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkProcess1WrapInTransaction.CheckedChanged
        SetStateOfGrpIsolationLevel(enmTransaction.Transaction1)
    End Sub

    Private Sub chkProcess2WrapInTransaction_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkProcess2WrapInTransaction.CheckedChanged
        SetStateOfGrpIsolationLevel(enmTransaction.Transaction2)
    End Sub

    Private Sub SetStateOfGrpIsolationLevel(ByVal penmTrans As enmTransaction)
        Select Case penmTrans
            Case enmTransaction.Transaction1
                If chkProcess1WrapInTransaction.Checked And _
                            Me.chkProcess1WrapInTransaction.Enabled Then
                    Me.grpProcess1IsolationLevel.Enabled = True
                Else
                    Me.grpProcess1IsolationLevel.Enabled = False
                End If
            Case enmTransaction.Transaction2
                If chkProcess2WrapInTransaction.Checked And _
                            Me.chkProcess2WrapInTransaction.Enabled Then
                    Me.grpProcess2IsolationLevel.Enabled = True
                Else
                    Me.grpProcess2IsolationLevel.Enabled = False
                End If
        End Select
    End Sub

    Private Sub CommitTrans(ByRef ptransX As SqlTransaction)
        Dim strMsg As String = "Are you sure you want to commit changes (if made) to the back-end database?"
        If MessageBox.Show(strMsg, "Commit Changes?", _
                MessageBoxButtons.YesNo, MessageBoxIcon.Question, _
                MessageBoxDefaultButton.Button2) = DialogResult.Yes Then
            ptransX.Commit()
            ptransX = Nothing
        End If
    End Sub

    Private Sub RollbackTrans(ByRef ptransX As SqlTransaction)
        ptransX.Rollback()
        ptransX = Nothing
    End Sub

    Private Function OperationToPerform( _
            ByVal penmTrans As enmTransaction) As enmOperationToPerform

        Dim Action As enmOperationToPerform
        Select Case penmTrans
            Case enmTransaction.Transaction1
                If Me.optOperationRead1.Checked Then
                    Action = enmOperationToPerform.ReadRecords
                ElseIf Me.optOperationAdd1.Checked Then
                    Action = enmOperationToPerform.AddRecord
                ElseIf Me.optOperationEdit1.Checked Then
                    Action = enmOperationToPerform.EditCurrentRecord
                ElseIf Me.optOperationDelete1.Checked Then
                    Action = enmOperationToPerform.DeleteCurrentRecord
                End If
            Case enmTransaction.Transaction2
                If Me.optOperationRead2.Checked Then
                    Action = enmOperationToPerform.ReadRecords
                ElseIf Me.optOperationAdd2.Checked Then
                    Action = enmOperationToPerform.AddRecord
                ElseIf Me.optOperationEdit2.Checked Then
                    Action = enmOperationToPerform.EditCurrentRecord
                ElseIf Me.optOperationDelete2.Checked Then
                    Action = enmOperationToPerform.DeleteCurrentRecord
                End If
        End Select
        Return Action

    End Function

    Private Function GetIsolationLevel(ByVal penmTrans As System.Data.IsolationLevel)
        Dim isolationLevelX As System.Data.IsolationLevel
        Select Case penmTrans
            Case enmTransaction.Transaction1
                If Me.optIsolation1ReadCommitted.Checked Then
                    isolationLevelX = IsolationLevel.ReadCommitted
                ElseIf Me.optIsolation1ReadUncommitted.Checked Then
                    isolationLevelX = IsolationLevel.ReadUncommitted
                ElseIf Me.optIsolation1RepeatableRead.Checked Then
                    isolationLevelX = IsolationLevel.RepeatableRead
                ElseIf Me.optIsolation1Serializable.Checked Then
                    isolationLevelX = IsolationLevel.Serializable
                End If
            Case enmTransaction.Transaction2
                If Me.optIsolation2ReadCommitted.Checked Then
                    isolationLevelX = IsolationLevel.ReadCommitted
                ElseIf Me.optIsolation2ReadUncommitted.Checked Then
                    isolationLevelX = IsolationLevel.ReadUncommitted
                ElseIf Me.optIsolation2RepeatableRead.Checked Then
                    isolationLevelX = IsolationLevel.RepeatableRead
                ElseIf Me.optIsolation2Serializable.Checked Then
                    isolationLevelX = IsolationLevel.Serializable
                End If
        End Select
        Return isolationLevelX
    End Function

    Private Sub PerformIndicationOperations(ByVal penmTrans As enmTransaction)
        Dim conX As SqlConnection
        Dim transX As SqlTransaction
        Dim isolationLevelX As IsolationLevel = GetIsolationLevel(penmTrans)
        Dim dataTableX As dsNw.ProductsDataTable
        Dim grdX As DataGrid
        Dim cmX As CurrencyManager
        Dim blnWrapInTransaction As Boolean
        Dim blnUpdateBackEnd As Boolean

        Select Case penmTrans
            Case enmTransaction.Transaction1
                conX = conNw1
                dataTableX = Me.objdsNw1.Products
                grdX = Me.grdProcess1Data
                blnWrapInTransaction = Me.chkProcess1WrapInTransaction.Checked
                blnUpdateBackEnd = Me.chkProcess1UpdateBackEnd.Checked
                transX = trans1
            Case enmTransaction.Transaction2
                conX = conNw2
                dataTableX = Me.objdsNw2.Products
                grdX = Me.grdProcess2Data
                blnWrapInTransaction = Me.chkProcess2WrapInTransaction.Checked
                blnUpdateBackEnd = Me.chkProcess2UpdateBackEnd.Checked
                transX = trans2
        End Select
        cmX = Me.BindingContext(dataTableX)

        'Open the connection
        If conX.State = ConnectionState.Closed Then
            conX.Open()
        End If

        'Set the connection for the commands
        Me.cmdProductsSelect.Connection = conX
        Me.cmdProductsInsert.Connection = conX
        Me.cmdProductsDelete.Connection = conX
        Me.cmdProductsUpdate.Connection = conX

        'Begin the transaction and associate it with the commands
        If blnWrapInTransaction Then
            If transX Is Nothing Then
                transX = conX.BeginTransaction(isolationLevelX)
            End If
            'EnableTransactionStartStopButtons(penmTrans, True)

            'Set the transaction for the commands
            Me.cmdProductsSelect.Transaction = transX
            Me.cmdProductsInsert.Transaction = transX
            Me.cmdProductsDelete.Transaction = transX
            Me.cmdProductsUpdate.Transaction = transX
            Select Case penmTrans
                Case enmTransaction.Transaction1
                    trans1 = transX
                Case enmTransaction.Transaction2
                    trans2 = transX
            End Select
        Else
            Me.cmdProductsSelect.Transaction = Nothing
            Me.cmdProductsInsert.Transaction = Nothing
            Me.cmdProductsDelete.Transaction = Nothing
            Me.cmdProductsUpdate.Transaction = Nothing
        End If

        Dim enmOperation As enmOperationToPerform = OperationToPerform(penmTrans)
        Select Case enmOperation
            Case enmOperationToPerform.ReadRecords
                'Clear the DataTable
                dataTableX.Clear()
                'Load the Data
                Try
                    Me.daProducts.Fill(dataTableX)
                Catch ex As Exception
                    Dim strMsg As String
                    strMsg = "Attempting to execute statement: " + ControlChars.NewLine
                    strMsg += ControlChars.NewLine
                    strMsg += ControlChars.Tab
                    strMsg += "Me.daProducts.Fill(dataTableX)"
                    strMsg += ControlChars.NewLine
                    strMsg += ControlChars.NewLine
                    MessageBox.Show(strMsg + ex.Message)
                End Try
                grdX.DataSource = dataTableX
            Case enmOperationToPerform.AddRecord
                dataTableX.AddProductsRow("Foo Pellets", False)
                dataTableX.DefaultView.Sort = "ProductId DESC"
                cmX.Position = 0
            Case enmOperationToPerform.EditCurrentRecord
                dataTableX.Rows(cmX.Position)("Discontinued") = _
                    Not dataTableX.Rows(cmX.Position)("Discontinued")
            Case enmOperationToPerform.DeleteCurrentRecord
                dataTableX.Rows(cmX.Position).Delete()
        End Select
        If blnUpdateBackEnd Then
            Try
                Me.daProducts.Update(dataTableX)
            Catch ex As Exception
                Dim strMsg As String
                strMsg = "During the attempting to update the back-end database, "
                strMsg += "the following error occurred" + ControlChars.NewLine + ControlChars.NewLine
                MessageBox.Show(strMsg + ex.Message)
            End Try
        End If

        If blnWrapInTransaction Then
            EnableTransactionStartStopButtons(penmTrans, True)
        End If

    End Sub

    Private Sub InitializeDataMachinery()
        Dim strConn As String
        Me.objdsNw1 = New TransactionInteractionExplorer.dsNw
        Me.objdsNw2 = New TransactionInteractionExplorer.dsNw
        Me.conNw1 = New SqlConnection
        Me.conNw2 = New SqlConnection
        strConn = "data source=""(local)"";initial catalog=Northwind;"
        strConn += "integrated security=SSPI;persist security info=False;"
        Me.conNw1.ConnectionString = strConn
        Me.conNw2.ConnectionString = strConn
        Me.daProducts = New SqlDataAdapter

        Me.cmdProductsDelete = New SqlCommand
        Me.cmdProductsInsert = New SqlCommand
        Me.cmdProductsSelect = New SqlCommand
        Me.cmdProductsUpdate = New SqlCommand

        'daProducts
        Me.daProducts.TableMappings.Add("Table", "Products")
        Me.daProducts.SelectCommand = Me.cmdProductsSelect
        Me.daProducts.InsertCommand = Me.cmdProductsInsert
        Me.daProducts.DeleteCommand = Me.cmdProductsDelete
        Me.daProducts.UpdateCommand = Me.cmdProductsUpdate
        'Me.daProducts.TableMappings.AddRange(New System.Data.Common.DataTableMapping() {New System.Data.Common.DataTableMapping("Table", "Products", New System.Data.Common.DataColumnMapping() {New System.Data.Common.DataColumnMapping("ProductID", "ProductID"), New System.Data.Common.DataColumnMapping("ProductName", "ProductName"), New System.Data.Common.DataColumnMapping("Discontinued", "Discontinued")})})

        'cmdProductsDelete
        Me.cmdProductsDelete.CommandText = "DELETE FROM Products WHERE (ProductID = @Original_ProductID) AND (Discontinued = " & _
        "@Original_Discontinued) AND (ProductName = @Original_ProductName)"
        Me.cmdProductsDelete.Connection = Me.conNw1
        Me.cmdProductsDelete.Parameters.Add(New SqlParameter("@Original_ProductID", System.Data.SqlDbType.Int, 4, System.Data.ParameterDirection.Input, False, CType(0, Byte), CType(0, Byte), "ProductID", System.Data.DataRowVersion.Original, Nothing))
        Me.cmdProductsDelete.Parameters.Add(New SqlParameter("@Original_Discontinued", System.Data.SqlDbType.Bit, 1, System.Data.ParameterDirection.Input, False, CType(0, Byte), CType(0, Byte), "Discontinued", System.Data.DataRowVersion.Original, Nothing))
        Me.cmdProductsDelete.Parameters.Add(New SqlParameter("@Original_ProductName", System.Data.SqlDbType.NVarChar, 40, System.Data.ParameterDirection.Input, False, CType(0, Byte), CType(0, Byte), "ProductName", System.Data.DataRowVersion.Original, Nothing))

        'cmdProductsInsert
        Me.cmdProductsInsert.CommandText = "INSERT INTO Products(ProductName, Discontinued) VALUES (@ProductName, @Discontinu" & _
        "ed); SELECT ProductID, ProductName, Discontinued FROM Products WHERE (ProductID " & _
        "= @@IDENTITY) ORDER BY ProductID DESC"
        Me.cmdProductsInsert.Connection = Me.conNw1
        Me.cmdProductsInsert.Parameters.Add(New SqlParameter("@ProductName", System.Data.SqlDbType.NVarChar, 40, "ProductName"))
        Me.cmdProductsInsert.Parameters.Add(New SqlParameter("@Discontinued", System.Data.SqlDbType.Bit, 1, "Discontinued"))

        'cmdProductsSelect
        Me.cmdProductsSelect.CommandText = "SELECT ProductID, ProductName, Discontinued FROM Products ORDER BY ProductID DESC" & _
        ""
        Me.cmdProductsSelect.Connection = Me.conNw1

        'cmdProductsUpdate
        Me.cmdProductsUpdate.CommandText = "UPDATE Products SET ProductName = @ProductName, Discontinued = @Discontinued WHER" & _
        "E (ProductID = @Original_ProductID) AND (Discontinued = @Original_Discontinued) " & _
        "AND (ProductName = @Original_ProductName); SELECT ProductID, ProductName, Discon" & _
        "tinued FROM Products WHERE (ProductID = @ProductID) ORDER BY ProductID DESC"
        Me.cmdProductsUpdate.Connection = Me.conNw1
        Me.cmdProductsUpdate.Parameters.Add(New SqlParameter("@ProductName", System.Data.SqlDbType.NVarChar, 40, "ProductName"))
        Me.cmdProductsUpdate.Parameters.Add(New SqlParameter("@Discontinued", System.Data.SqlDbType.Bit, 1, "Discontinued"))
        Me.cmdProductsUpdate.Parameters.Add(New SqlParameter("@Original_ProductID", System.Data.SqlDbType.Int, 4, System.Data.ParameterDirection.Input, False, CType(0, Byte), CType(0, Byte), "ProductID", System.Data.DataRowVersion.Original, Nothing))
        Me.cmdProductsUpdate.Parameters.Add(New SqlParameter("@Original_Discontinued", System.Data.SqlDbType.Bit, 1, System.Data.ParameterDirection.Input, False, CType(0, Byte), CType(0, Byte), "Discontinued", System.Data.DataRowVersion.Original, Nothing))
        Me.cmdProductsUpdate.Parameters.Add(New SqlParameter("@Original_ProductName", System.Data.SqlDbType.NVarChar, 40, System.Data.ParameterDirection.Input, False, CType(0, Byte), CType(0, Byte), "ProductName", System.Data.DataRowVersion.Original, Nothing))
        Me.cmdProductsUpdate.Parameters.Add(New SqlParameter("@ProductID", System.Data.SqlDbType.Int, 4, "ProductID"))

        'Set timeouts on the commands
        Me.cmdProductsSelect.CommandTimeout = kCommandTimeout
        Me.cmdProductsInsert.CommandTimeout = kCommandTimeout
        Me.cmdProductsUpdate.CommandTimeout = kCommandTimeout
        Me.cmdProductsDelete.CommandTimeout = kCommandTimeout

    End Sub

    Private Sub EnableTransactionStartStopButtons( _
            ByVal penmTrans As enmTransaction, _
            ByVal pblnTransactionInProgress As Boolean)
        Select Case penmTrans
            Case enmTransaction.Transaction1
                Me.btnProcess1Commit.Enabled = pblnTransactionInProgress
                Me.btnProcess1RollBack.Enabled = pblnTransactionInProgress
                Me.btnClearGrid1.Enabled = Not pblnTransactionInProgress
            Case enmTransaction.Transaction2
                Me.btnProcess2Commit.Enabled = pblnTransactionInProgress
                Me.btnProcess2RollBack.Enabled = pblnTransactionInProgress
                Me.btnClearGrid2.Enabled = Not pblnTransactionInProgress
        End Select
    End Sub

End Class
