Public Class clsDiscards
    Private Sub ChangeData(ByVal pmode As enmOperationToPerform)
        Dim intPos As Int32
        intPos = Me.BindingContext(Me.objdsNw1.Products).Position
        If intPos = -1 Then
            Dim strMsg As String
            strMsg = "There is no data to process. Do you wish to load data from the back-end database?"
            If MessageBox.Show(strMsg, "Load Data?", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1) = DialogResult.Yes Then
                LoadData1()
                intPos = Me.BindingContext(Me.objdsNw1.Products).Position
            Else
                Return
            End If
        End If
        Select Case pmode
            Case enmOperationToPerform.AddRecord
                Me.objdsNw1.Products.AddProductsRow("Foo Pellets", False)
                SortGrid()
            Case enmOperationToPerform.EditRecord
                Me.objdsNw1.Products.Rows(intPos)("Discontinued") = _
                    Not Me.objdsNw1.Products.Rows(intPos)("Discontinued")
            Case enmOperationToPerform.DeleteRecord
                Me.BindingContext(Me.objdsNw1.Products).Position = _
                    Me.grdTrans1Data.CurrentRowIndex
                Do While Me.objdsNw1.Products.Rows(intPos).RowState = DataRowState.Deleted
                    intPos += 1
                Loop
                Try
                    Me.objdsNw1.Products.Rows(intPos).Delete()
                Catch ex As Exception
                    MessageBox.Show("[ChangeData] " + ex.Message)
                End Try
            Case Else
                MessageBox.Show("[ChangeData] Unknown value for mode enum")
        End Select

        If Me.chkUpdateBackEnd.Checked Then
            If Me.chkWrapInTransaction.Checked Then
                Me.conNw1.Open()
                If Me.optIsolation1ReadCommitted.Checked Then
                    'IsolationLevel.ReadUncommitted is the default, so no parameter need be passed
                    'to the BeginTransaction method
                    trans1 = Me.conNw1.BeginTransaction
                    'But you could do it explicitly with the following statement:
                    'trans1 = Me.conNw1.BeginTransaction(IsolationLevel.ReadCommitted)
                ElseIf Me.optIsolation1ReadUncommitted.Checked Then
                    trans1 = Me.conNw1.BeginTransaction(IsolationLevel.ReadUncommitted)
                ElseIf Me.optIsolation1RepeatableRead.Checked Then
                    trans1 = Me.conNw1.BeginTransaction(IsolationLevel.RepeatableRead)
                ElseIf Me.optIsolation1Serializable.Checked Then
                    trans1 = Me.conNw1.BeginTransaction(IsolationLevel.Serializable)
                End If
                Me.cmdProductsInsert.Transaction = trans1
                Me.cmdProductsUpdate.Transaction = trans1
                Me.cmdProductsDelete.Transaction = trans1
            End If

            '----------------------------------------
            Me.daProducts.Update(Me.objdsNw1)
            Me.objdsNw1.AcceptChanges()
            Me.objdsNw1.Products.DefaultView.Sort = "ProductId DESC"
            Me.BindingContext(Me.objdsNw1.Products).Position = 0
            '----------------------------------------

            If Me.chkWrapInTransaction.Checked Then
                Dim strMsg As String
                strMsg += "The transaction on Connection 1, inside which data has been changed, is pending. "
                strMsg += "A command to read the same data, under the control of a different transaction on "
                strMsg += "Connection 2, will now be issued. "
                strMsg += ControlChars.NewLine + ControlChars.NewLine
                strMsg += "If the read is successful, the data will be displayed in the lower datagrid. "
                strMsg += "You will then be prompted to let the first transaction be rolled back."
                MessageBox.Show(strMsg)
                LoadData2()
                MessageBox.Show("Press OK to roll back the first (data-changing) transaction.")
                trans1.Rollback()
                Me.conNw1.Close()
            End If
        End If

    End Sub


End Class
