Public Class frmShowRecordVersions
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents grdProductsServerVersion As System.Windows.Forms.DataGrid
    Friend WithEvents grdProductsLocalVersion As System.Windows.Forms.DataGrid
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents btnHelp As System.Windows.Forms.Button
    Friend WithEvents btnOverwriteSelected As System.Windows.Forms.Button
    Friend WithEvents btnOverwriteNone As System.Windows.Forms.Button
    Friend WithEvents btnOverwriteAll As System.Windows.Forms.Button
    Friend WithEvents dtsProductsLocal As System.Windows.Forms.DataGridTableStyle
    Friend WithEvents colProductName As System.Windows.Forms.DataGridTextBoxColumn
    Friend WithEvents colProductId As System.Windows.Forms.DataGridTextBoxColumn
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.grdProductsServerVersion = New System.Windows.Forms.DataGrid
    Me.grdProductsLocalVersion = New System.Windows.Forms.DataGrid
    Me.dtsProductsLocal = New System.Windows.Forms.DataGridTableStyle
    Me.colProductId = New System.Windows.Forms.DataGridTextBoxColumn
    Me.colProductName = New System.Windows.Forms.DataGridTextBoxColumn
    Me.Label1 = New System.Windows.Forms.Label
    Me.Label2 = New System.Windows.Forms.Label
    Me.btnOverwriteSelected = New System.Windows.Forms.Button
    Me.btnOverwriteNone = New System.Windows.Forms.Button
    Me.btnHelp = New System.Windows.Forms.Button
    Me.btnOverwriteAll = New System.Windows.Forms.Button
    CType(Me.grdProductsServerVersion, System.ComponentModel.ISupportInitialize).BeginInit()
    CType(Me.grdProductsLocalVersion, System.ComponentModel.ISupportInitialize).BeginInit()
    Me.SuspendLayout()
    '
    'grdProductsServerVersion
    '
    Me.grdProductsServerVersion.DataMember = ""
    Me.grdProductsServerVersion.Enabled = False
    Me.grdProductsServerVersion.HeaderForeColor = System.Drawing.SystemColors.ControlText
    Me.grdProductsServerVersion.Location = New System.Drawing.Point(16, 232)
    Me.grdProductsServerVersion.Name = "grdProductsServerVersion"
    Me.grdProductsServerVersion.Size = New System.Drawing.Size(616, 120)
    Me.grdProductsServerVersion.TabIndex = 1
    '
    'grdProductsLocalVersion
    '
    Me.grdProductsLocalVersion.DataMember = ""
    Me.grdProductsLocalVersion.HeaderForeColor = System.Drawing.SystemColors.ControlText
    Me.grdProductsLocalVersion.Location = New System.Drawing.Point(16, 64)
    Me.grdProductsLocalVersion.Name = "grdProductsLocalVersion"
    Me.grdProductsLocalVersion.Size = New System.Drawing.Size(616, 120)
    Me.grdProductsLocalVersion.TabIndex = 2
    Me.grdProductsLocalVersion.TableStyles.AddRange(New System.Windows.Forms.DataGridTableStyle() {Me.dtsProductsLocal})
    '
    'dtsProductsLocal
    '
    Me.dtsProductsLocal.DataGrid = Me.grdProductsLocalVersion
    Me.dtsProductsLocal.GridColumnStyles.AddRange(New System.Windows.Forms.DataGridColumnStyle() {Me.colProductId, Me.colProductName})
    Me.dtsProductsLocal.HeaderForeColor = System.Drawing.SystemColors.ControlText
    Me.dtsProductsLocal.MappingName = "Products"
    '
    'colProductId
    '
    Me.colProductId.Format = ""
    Me.colProductId.FormatInfo = Nothing
    Me.colProductId.HeaderText = "Product Id"
    Me.colProductId.MappingName = "ProductId"
    Me.colProductId.Width = 40
    '
    'colProductName
    '
    Me.colProductName.Format = ""
    Me.colProductName.FormatInfo = Nothing
    Me.colProductName.HeaderText = "Product Name"
    Me.colProductName.MappingName = "ProductName"
    Me.colProductName.Width = 250
    '
    'Label1
    '
    Me.Label1.Location = New System.Drawing.Point(16, 200)
    Me.Label1.Name = "Label1"
    Me.Label1.Size = New System.Drawing.Size(168, 23)
    Me.Label1.TabIndex = 3
    Me.Label1.Text = "Wersja z bazy danych"
    Me.Label1.TextAlign = System.Drawing.ContentAlignment.BottomLeft
    '
    'Label2
    '
    Me.Label2.Location = New System.Drawing.Point(16, 32)
    Me.Label2.Name = "Label2"
    Me.Label2.Size = New System.Drawing.Size(168, 23)
    Me.Label2.TabIndex = 4
    Me.Label2.Text = "Wersja lokalna"
    Me.Label2.TextAlign = System.Drawing.ContentAlignment.BottomLeft
    '
    'btnOverwriteSelected
    '
    Me.btnOverwriteSelected.Location = New System.Drawing.Point(264, 376)
    Me.btnOverwriteSelected.Name = "btnOverwriteSelected"
    Me.btnOverwriteSelected.Size = New System.Drawing.Size(128, 32)
    Me.btnOverwriteSelected.TabIndex = 6
    Me.btnOverwriteSelected.Text = "Nadpisz WYBRANE"
    '
    'btnOverwriteNone
    '
    Me.btnOverwriteNone.Location = New System.Drawing.Point(400, 376)
    Me.btnOverwriteNone.Name = "btnOverwriteNone"
    Me.btnOverwriteNone.Size = New System.Drawing.Size(128, 32)
    Me.btnOverwriteNone.TabIndex = 10
    Me.btnOverwriteNone.Text = "NIE nadpisuj"
    '
    'btnHelp
    '
    Me.btnHelp.Location = New System.Drawing.Point(504, 16)
    Me.btnHelp.Name = "btnHelp"
    Me.btnHelp.Size = New System.Drawing.Size(128, 32)
    Me.btnHelp.TabIndex = 11
    Me.btnHelp.Text = "Opis"
    '
    'btnOverwriteAll
    '
    Me.btnOverwriteAll.Location = New System.Drawing.Point(128, 376)
    Me.btnOverwriteAll.Name = "btnOverwriteAll"
    Me.btnOverwriteAll.Size = New System.Drawing.Size(128, 32)
    Me.btnOverwriteAll.TabIndex = 12
    Me.btnOverwriteAll.Text = "Nadpisz WSZYSTKIE"
    '
    'frmShowRecordVersions
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(648, 426)
    Me.Controls.Add(Me.btnOverwriteAll)
    Me.Controls.Add(Me.btnHelp)
    Me.Controls.Add(Me.btnOverwriteNone)
    Me.Controls.Add(Me.btnOverwriteSelected)
    Me.Controls.Add(Me.Label2)
    Me.Controls.Add(Me.Label1)
    Me.Controls.Add(Me.grdProductsLocalVersion)
    Me.Controls.Add(Me.grdProductsServerVersion)
    Me.Name = "frmShowRecordVersions"
    Me.Text = "Zmiany w rekordach z konfliktami"
    CType(Me.grdProductsServerVersion, System.ComponentModel.ISupportInitialize).EndInit()
    CType(Me.grdProductsLocalVersion, System.ComponentModel.ISupportInitialize).EndInit()
    Me.ResumeLayout(False)

  End Sub

#End Region

    Dim tblLocalVersion As New dsNw.ProductsDataTable
    Dim tblServerVersion As New dsNw.ProductsDataTable
    Dim cmdProductSelectServerVersions As New SqlClient.SqlCommand
    Dim cmdProductUpdate As New SqlClient.SqlCommand
    Dim daProducts As New SqlClient.SqlDataAdapter
    Dim conNw As New SqlClient.SqlConnection
    Dim rowErrors As DataRow()

    Private Enum enmOverwriteMode
        Selected
        All
    End Enum

    Public Sub New(ByVal prowErrors As DataRow())
        'Run default constructor for this form
        Me.New()
        'Copy the array of DataRows into a DataTable that can
        'be used as the data source for a DataGrid
        Dim strIDs As String
        rowErrors = prowErrors
        For Each rowX As DataRow In rowErrors
            Dim rowY As DataRow
            rowY = tblLocalVersion.NewRow
            rowY("ProductID") = rowX("ProductId")
            rowY("ProductName") = rowX("ProductName")
            strIDs += CStr(rowY("ProductID")) + ","
            tblLocalVersion.Rows.Add(rowY)
        Next
        Me.grdProductsLocalVersion.DataSource = tblLocalVersion

        'Trim the trailing comma from the string of ProductIDs
        strIDs = strIDs.Substring(0, Len(strIDs) - 1)
        Me.cmdProductSelectServerVersions.CommandText = _
            "SELECT ProductID, ProductName FROM Products " + _
            "WHERE ProductID IN (" + strIDs + ") " + _
            "ORDER BY ProductName"
        Me.conNw.ConnectionString = "integrated security=SSPI;data source='(local)';" + _
             "persist security info=False;initial catalog=Northwind"
        Me.cmdProductSelectServerVersions.Connection = Me.conNw
        Me.daProducts.SelectCommand = Me.cmdProductSelectServerVersions
        Me.daProducts.Fill(tblServerVersion)
        Me.grdProductsServerVersion.DataSource = tblServerVersion

        Me.cmdProductUpdate.Connection = Me.conNw
    End Sub

    Private Sub btnHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnHelp.Click
        Dim frmX As New frmHelp("..\zzHelp_HandlingConflictingVersions.txt")
        frmX.Show()
    End Sub

    Private Sub ClearErrorFlags()
        For Each rowX As DataRow In rowErrors
            rowX.ClearErrors()
        Next
    End Sub

    Private Sub btnOverwriteNone_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOverwriteNone.Click
        ClearErrorFlags()
        Me.Close()
    End Sub

    Private Sub btnOverwriteAll_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOverwriteAll.Click
        OverwriteServerRecords(enmOverwriteMode.All)
        ClearErrorFlags()
        Me.Close()
    End Sub

    Private Sub btnOverwriteSelected_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOverwriteSelected.Click
        OverwriteServerRecords(enmOverwriteMode.Selected)
        ClearErrorFlags()
        Me.Close()
    End Sub

    Private Sub OverwriteServerRecords(ByVal penmMode As enmOverwriteMode)
        Dim intCtr As Int32 = 0
        Try
            For Each rowX As DataRow In Me.grdProductsLocalVersion.DataSource
                Select Case penmMode
                    Case enmOverwriteMode.All
                        UpdateServer(rowX)
                        intCtr += 1
                    Case enmOverwriteMode.Selected
                        If Me.grdProductsLocalVersion.IsSelected(intCtr) Then
                            UpdateServer(rowX)
                        End If
                        intCtr += 1
                End Select
            Next
            MessageBox.Show("Records saved.")
        Catch ex As Exception
            Dim strMsg As String
            strMsg += "Error during attempt to save records: "
            strMsg += ControlChars.NewLine
            strMsg += ex.Message
            MessageBox.Show(strMsg)
        End Try

    End Sub

    Private Sub UpdateServer(ByVal prowX As DataRow)

        Dim strProductName As String = prowX("ProductName")
        Dim intProductID As Int32 = prowX("ProductID")
        Dim strCmdText As String

        strCmdText += "UPDATE Products SET ProductName = '" + strProductName + "' "
        strCmdText += "WHERE (ProductID = " + CStr(intProductID) + ")"
        Me.cmdProductUpdate.CommandText = strCmdText

        Try
            Me.conNw.Open()
            Me.cmdProductUpdate.ExecuteNonQuery()
        Catch ex As Exception
            Throw ex
        Finally
            Me.conNw.Close()
        End Try

    End Sub

End Class
