Imports System
Imports System.Drawing
Imports System.Drawing.Printing

Public Class PrintPreviewDialogExample
  Inherits System.Windows.Forms.Form

  Private WithEvents PrintPreviewDialog1 As New PrintPreviewDialog
  Private WithEvents printDoc As New PrintDocument
  Private WithEvents btnPrint As New System.Windows.Forms.Button

  Public Sub New()
    InitializeComponent()
  End Sub

  Private Sub InitializeComponent()
    'Ustawienie rozmiaru, likalizacji i nazwy.
    Me.PrintPreviewDialog1.ClientSize = New System.Drawing.Size(400, 300)
    Me.PrintPreviewDialog1.Location = New System.Drawing.Point(29, 29)
    Me.PrintPreviewDialog1.Name = "PrintPreviewDialog1"
    ' Ustawienie minimalnej wielkoci okna..
    Me.PrintPreviewDialog1.MinimumSize = New System.Drawing.Size(375, 250)
    ' Ustawienie waciwoci UseAntiAlias na true, co powoduje
    ' wczenie wygadzania czcionek.
    Me.PrintPreviewDialog1.UseAntiAlias = True
    Me.btnPrint.Location = New System.Drawing.Point(86, 180)
    Me.btnPrint.Name = "btnPrint"
    Me.btnPrint.Size = New System.Drawing.Size(96, 32)
    Me.btnPrint.Text = "Drukuj"
    Me.Controls.Add(Me.btnPrint)
    Me.Name = "PrintingExample"
    Me.Text = "Przykad drukowania"
    AddHandler printDoc.PrintPage, AddressOf Me.OnPrintPage
  End Sub

  Private Sub OnPrintPage(ByVal sender As Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs)
    'Poniszy kod generuje prosty tekst dokumentu w formancie.
    Dim text As String = "Przykad uycia PrintPreviewDialog"
    Dim printFont As New Font("Arial", 35, System.Drawing.FontStyle.Regular)
    e.Graphics.DrawString(text, printFont, System.Drawing.Brushes.Black, 10, 10)
  End Sub

  Private Sub btnPrint_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles btnPrint.Click
    ' Doczenie procedury drukowania do zdarzenia PrintPage
    PrintPreviewDialog1.Document = printDoc
    ' Wywoanie metody ShowDialog
    PrintPreviewDialog1.ShowDialog()
  End Sub

  Public Shared Sub Main()
    Application.Run(New PrintPreviewDialogExample)
  End Sub
End Class
