Imports System
Imports System.Drawing
Imports System.Windows.Forms

Public Class ComboBoxExample
    Inherits System.Windows.Forms.Form

    Private btnAdd As New Button
    Private txtMessage As New TextBox
    Private cboItems As New ComboBox
    Private btnShowSelected As New Button
    Private btnFind As New Button
    Private lblDisplay As New Label

    Public Sub New()
        MyBase.New()
        Me.InitializeComponent()
    End Sub

    Private Sub InitializeComponent()
        Me.btnAdd.Location = New Point(248, 32)
        Me.btnAdd.Size = New Size(50, 24)
        Me.btnAdd.TabIndex = 1
        Me.btnAdd.Text = "Dodaj"
        AddHandler Me.btnAdd.Click, AddressOf Me.btnAdd_Click
        Me.cboItems.Anchor = ((AnchorStyles.Bottom Or AnchorStyles.Left) Or _
          AnchorStyles.Right)
        Me.cboItems.DropDownWidth = 280
        Me.cboItems.Items.AddRange(New Object() {"Element 1", "Element 2", _
          "Element 3", "Element 4", "Element 5"})
        Me.cboItems.Location = New Point(8, 248)
        Me.cboItems.Size = New Size(280, 21)
        Me.cboItems.TabIndex = 7
        Me.btnShowSelected.Location = New Point(8, 128)
        Me.btnShowSelected.Size = New Size(280, 24)
        Me.btnShowSelected.TabIndex = 4
        Me.btnShowSelected.Text = "Ktry element jest zaznaczony?"
        AddHandler Me.btnShowSelected.Click, AddressOf Me.btnShowSelected_Click
        Me.txtMessage.Location = New Point(8, 32)
        Me.txtMessage.Size = New Size(232, 20)
        Me.txtMessage.TabIndex = 5
        Me.txtMessage.Text = ""
        Me.btnFind.Location = New Point(248, 64)
        Me.btnFind.Size = New Size(50, 24)
        Me.btnFind.TabIndex = 3
        Me.btnFind.Text = "Szukaj"
        AddHandler Me.btnFind.Click, AddressOf Me.btnFind_Click
        Me.lblDisplay.Location = New Point(8, 224)
        Me.lblDisplay.Size = New Size(144, 23)
        Me.lblDisplay.TabIndex = 0
        Me.lblDisplay.Text = "Test formantu ComboBox"
        Me.AutoScaleBaseSize = New Size(5, 13)
        Me.ClientSize = New Size(304, 273)
        Me.Controls.AddRange(New Control() {Me.cboItems, Me.txtMessage, _
          Me.btnShowSelected, _
          Me.btnFind, Me.btnAdd, Me.lblDisplay})
        Me.Text = "Test formantu ComboBox"
    End Sub

    Private Sub btnAdd_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        cboItems.Items.Add(txtMessage.Text)

    End Sub

    Private Sub btnFind_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim index As Integer

        index = cboItems.FindString(txtMessage.Text)

        cboItems.SelectedIndex = index
    End Sub

    Private Sub btnShowSelected_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim selectedIndex As Integer
        selectedIndex = cboItems.SelectedIndex
        Dim selectedItem As Object
        selectedItem = cboItems.SelectedItem
        MessageBox.Show("Tekst wybranego elementu: " & selectedItem.ToString() & _
          Microsoft.VisualBasic.Constants.vbCrLf & "Index: " & selectedIndex.ToString())
    End Sub

    Shared Sub Main()
        Application.Run(New ComboBoxExample)
    End Sub
End Class
