﻿' Wymaga referencji do System.Xml.
Imports System.Xml
Imports System.IO

Public Class Form1
    Private Sub btnGo_Click() Handles btnGo.Click
        Using memory_stream As New MemoryStream()
            Dim xml_text_writer As New XmlTextWriter(memory_stream, System.Text.Encoding.UTF8)

            ' Utworzenie wcięć, aby treść była ładnie sformatowana.
            xml_text_writer.Formatting = Formatting.Indented
            xml_text_writer.Indentation = 4

            ' Deklaracja XML.
            xml_text_writer.WriteStartDocument(True)

            ' Początek węzła Employees.
            xml_text_writer.WriteStartElement("Employees")

            ' Kilka elementów Employee.
            MakeEmployee(xml_text_writer, "Albert", "Anders", 11111)
            MakeEmployee(xml_text_writer, "Betty", "Beach", 22222)
            MakeEmployee(xml_text_writer, "Chuck", "Cinder", 33333)

            ' Koniec węzła Employees.
            xml_text_writer.WriteEndElement()

            ' Koniec dokumentu.
            xml_text_writer.WriteEndDocument()
            xml_text_writer.Flush()

            ' Wyświetlenie wyniku przy użyciu obiektu StreamReader.
            Using stream_reader As New StreamReader(memory_stream)

                memory_stream.Seek(0, SeekOrigin.Begin)
                txtResult.Text = stream_reader.ReadToEnd()
            End Using ' stream_reader 

            ' Zamknięcie XmlTextWriter.
            xml_text_writer.Close()
        End Using ' memory_stream
    End Sub

    ' Dodanie węzła Employee do dokumentu.
    Private Sub MakeEmployee(ByVal xml_text_writer As XmlTextWriter, ByVal first_name As String, ByVal last_name As String, ByVal emp_id As Integer)
        ' Początek elementu Employee.
        xml_text_writer.WriteStartElement("Employee")

        ' Zapisanie elementu FirstName.
        xml_text_writer.WriteStartElement("FirstName")
        xml_text_writer.WriteString(first_name)
        xml_text_writer.WriteEndElement()

        ' Zapisanie elementu LastName.
        xml_text_writer.WriteStartElement("LastName")
        xml_text_writer.WriteString(last_name)
        xml_text_writer.WriteEndElement()

        ' Zapisanie elementu EmployeeId.
        xml_text_writer.WriteStartElement("EmployeeId")
        xml_text_writer.WriteString(emp_id.ToString)
        xml_text_writer.WriteEndElement()

        ' Zamknięcie elementu Employee.
        xml_text_writer.WriteEndElement()
    End Sub
End Class
