﻿' NOTE: If you change the class name "Service1" here, you must also update the reference to "Service1" in App.config.
Public Class QuoteService
    Implements IQuoteService

    Public Function GetData(ByVal value As Integer) As String Implements IQuoteService.GetData
        Return String.Format("You entered: {0}", value)
    End Function

    Public Function GetDataUsingDataContract(ByVal composite As CompositeType) As CompositeType Implements IQuoteService.GetDataUsingDataContract
        If composite.BoolValue Then
            composite.StringValue = (composite.StringValue & "Suffix")
        End If
        Return composite
    End Function

    ' Return a random quote.
    Public Function GetQuote() As String Implements IQuoteService.GetQuote
        Dim quotes() As String = { _
            "I stand by all the misstatements that I've made. -- Dan Quayle", _
            "You can observe a lot just by watching. -- Yogi Berra", _
            "Things are more like they are now than they have ever been. -- Gerald Ford", _
            "A zebra  does not change its spots. -- Al Gore", _
            "If it weren't for electricity, we'd all be watching television by candlelight. -- George Gobel", _
            "Listen, everyone is entitled to my opinion. -- Madonna", _
            "A friend is someone who's there when he needs you. -- Anon", _
            "I'm gonna live forever, or die trying. -- Joseph Heller (Catch 22)", _
            "Trees cause more pollution than automobiles do. -- Ronald Regan", _
            "Two nations divided by a common language. -- Winston Churchill" _
        }

        ' Return a random quote.
        Dim rand As New Random
        Return quotes(rand.Next(0, quotes.Length))
    End Function
End Class
