﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        Dim emp_list As New EmployeeCollection
        emp_list.Add(New Employee("Ann", "Anderson"))
        emp_list.Add(New Employee("Bart", "Baskerville"))
        emp_list.Add(New Employee("Candy", "Cant"))
        emp_list.Add(New Employee("Durk", "Distant"))
        emp_list.Add(New Employee("Edwina", "Evers"))

        Dim txt As String = ""
        For Each emp As Employee In emp_list
            txt &= emp.ToString & vbCrLf
        Next emp

        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub
End Class

Public Class Employee
    Private m_FirstName As String
    Private m_LastName As String
    Public Sub New(ByVal first_name As String, ByVal last_name As String)
        m_FirstName = first_name
        m_LastName = last_name
    End Sub
    Public Overrides Function ToString() As String
        Return m_FirstName & " " & m_LastName
    End Function
End Class

' Kolekcja ze ścisłą kontrolą typów obiektów Employee.
Public Class EmployeeCollection
    Inherits CollectionBase

    ' Dodaje obiekt Employee.
    Public Sub Add(ByVal value As Employee)
        List.Add(value)
    End Sub

    ' Zwraca True, jeśli kolekcja zawiera tego pracownika.
    Public Function Contains(ByVal value As Employee) As Boolean
        Return List.Contains(value)
    End Function

    ' Zwraca indeks tego pracownika.
    Public Function IndexOf(ByVal value As Employee) As Integer
        Return List.IndexOf(value)
    End Function

    ' Wstawia nowego pracownika.
    Public Sub Insert(ByVal index As Integer, ByVal value As Employee)
        List.Insert(index, value)
    End Sub

    ' Zwraca pracownika znajdującego się w tym miejscu.
    Default Public ReadOnly Property Item(ByVal index As Integer) As Employee
        Get
            Return DirectCast(List.Item(index), Employee)
        End Get
    End Property

    ' Usuwa pracownika.
    Public Sub Remove(ByVal value As Employee)
        List.Remove(value)
    End Sub
End Class
