﻿Imports System.ComponentModel

<ToolboxBitmap(GetType(SmileyFace), "SmileyFaceTool.bmp")> _
Public Class SmileyFace
    ' Własność FaceColor.
    Private m_FaceColor As Color = Color.Yellow
    <Description("Kolor buźki."), _
     Category("Wygląd")> _
    Public Property FaceColor() As Color
        Get
            Return m_FaceColor
        End Get
        Set(ByVal value As Color)
            m_FaceColor = value
            Me.Invalidate()
        End Set
    End Property

    ' Własność NoseColor.
    Private m_NoseColor As Color = Color.PaleGreen
    <Description("Kolor nosa."), _
     Category("Wygląd")> _
    Public Property NoseColor() As Color
        Get
            Return m_NoseColor
        End Get
        Set(ByVal value As Color)
            m_NoseColor = value
            Me.Invalidate()
        End Set
    End Property

    ' The EyeColor property.
    Private m_EyeColor As Color = Color.White
    <Description("Kolor 'białka' oczu."), _
     Category("Wygląd")> _
    Public Property EyeColor() As Color
        Get
            Return m_EyeColor
        End Get
        Set(ByVal value As Color)
            m_EyeColor = value
            Me.Invalidate()
        End Set
    End Property

    ' Własność PupilColor.
    Private m_PupilColor As Color = Color.Black
    <Description("Kolor źrenicy."), _
     Category("Wygląd")> _
    Public Property PupilColor() As Color
        Get
            Return m_PupilColor
        End Get
        Set(ByVal value As Color)
            m_PupilColor = value
            Me.Invalidate()
        End Set
    End Property

    ' Rysowanie buźki.
    Private Sub SmileyFace_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles Me.Paint
        e.Graphics.Clear(Me.BackColor)
        e.Graphics.SmoothingMode = Drawing2D.SmoothingMode.HighQuality

        ' Buźka.
        Dim face_rect As New Rectangle(0, 0, _
            Me.ClientSize.Width - 1, _
            Me.ClientSize.Height - 1)
        e.Graphics.FillEllipse( _
            New SolidBrush(m_FaceColor), _
            face_rect)
        e.Graphics.DrawEllipse( _
            New Pen(Me.ForeColor), face_rect)

        ' Uśmiech.
        Dim smile_rect As New Rectangle( _
            CInt(Me.ClientSize.Width * 0.15), _
            CInt(Me.ClientSize.Height * 0.15), _
            CInt(Me.ClientSize.Width * 0.7), _
            CInt(Me.ClientSize.Height * 0.7))
        e.Graphics.DrawArc( _
            New Pen(Me.ForeColor), _
            smile_rect, 20, 140)

        ' Oczy.
        Dim eye_rect As New Rectangle( _
            CInt(Me.ClientSize.Width * 0.2), _
            CInt(Me.ClientSize.Height * 0.2), _
            CInt(Me.ClientSize.Width * 0.2), _
            CInt(Me.ClientSize.Height * 0.25))
        e.Graphics.FillEllipse( _
            New SolidBrush(m_EyeColor), _
            eye_rect)
        e.Graphics.DrawEllipse( _
            New Pen(Me.ForeColor), _
            eye_rect)
        Dim pupil_rect As New Rectangle( _
            CInt(Me.ClientSize.Width * 0.3), _
            CInt(Me.ClientSize.Height * 0.3), _
            CInt(Me.ClientSize.Width * 0.1), _
            CInt(Me.ClientSize.Height * 0.125))
        e.Graphics.FillEllipse( _
            Brushes.Black, pupil_rect)

        eye_rect.Offset(CInt(Me.ClientSize.Width * 0.4), 0)
        e.Graphics.FillEllipse( _
            New SolidBrush(m_EyeColor), _
            eye_rect)
        e.Graphics.DrawEllipse( _
            New Pen(Me.ForeColor), _
            eye_rect)
        pupil_rect.Offset(CInt(Me.ClientSize.Width * 0.4), 0)
        e.Graphics.FillEllipse( _
            Brushes.Black, pupil_rect)

        ' Nos.
        Dim nose_rect As New Rectangle( _
            CInt(Me.ClientSize.Width * 0.4), _
            CInt(Me.ClientSize.Height * 0.45), _
            CInt(Me.ClientSize.Width * 0.2), _
            CInt(Me.ClientSize.Height * 0.25))
        e.Graphics.FillEllipse( _
            New SolidBrush(m_NoseColor), _
            nose_rect)
        e.Graphics.DrawEllipse( _
            New Pen(Me.ForeColor), _
            nose_rect)
    End Sub

    ' Wymuszenie ponownego narysowania całej kontrolki.
    Private Sub SmileyFace_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Resize
        Me.Invalidate()
    End Sub
End Class
