﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Tworzenie danych.
        Dim all_customers As New List(Of Person)
        all_customers.Add(New Person() With {.FirstName = "Ben", .LastName = "Best", .CustId = 2})
        all_customers.Add(New Person() With {.FirstName = "Frank", .LastName = "Fix", .CustId = 4})
        all_customers.Add(New Person() With {.FirstName = "Ann", .LastName = "Archer", .CustId = 5})
        all_customers.Add(New Person() With {.FirstName = "Edna", .LastName = "Ever", .CustId = 3})
        all_customers.Add(New Person() With {.FirstName = "Carly", .LastName = "Cant", .CustId = 6})
        all_customers.Add(New Person() With {.FirstName = "Dan", .LastName = "Dump", .CustId = 1})

        Dim all_orders As New List(Of Order)
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 103, .OrderDate = #4/12/2008#})
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 101, .OrderDate = #4/4/2008#})
        all_orders.Add(New Order() With {.CustId = 3, .OrderId = 102, .OrderDate = #4/7/2008#})
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 104, .OrderDate = #4/15/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 106, .OrderDate = #4/23/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 100, .OrderDate = #4/7/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 105, .OrderDate = #4/19/2008#})
        all_orders.Add(New Order() With {.CustId = 3, .OrderId = 107, .OrderDate = #4/29/2008#})
        all_orders.Add(New Order() With {.CustId = 4, .OrderId = 108, .OrderDate = #5/2/2008#})
        all_orders.Add(New Order() With {.CustId = 5, .OrderId = 109, .OrderDate = #5/11/2008#})
        all_orders.Add(New Order() With {.CustId = 6, .OrderId = 110, .OrderDate = #5/15/2008#})

        Dim all_order_items As New List(Of OrderItem)
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Blue"})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Dun"})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Cerise"})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Argent"})
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Apple"})
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Cherry"})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Ash"})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Cat"})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Beech"})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Bat"})
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Banana"})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Dog"})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Choke Cherry"})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Ape"})
        all_order_items.Add(New OrderItem() With {.OrderId = 105, .Description = "Ace"})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Ball"})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Axe"})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Club"})
        all_order_items.Add(New OrderItem() With {.OrderId = 106, .Description = "Airplane"})
        all_order_items.Add(New OrderItem() With {.OrderId = 107, .Description = "Air"})

        all_order_items.Add(New OrderItem() With {.OrderId = 108, .Description = "Arctic"})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Alph"})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Beta"})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Gamma"})
        all_order_items.Add(New OrderItem() With {.OrderId = 110, .Description = "Ask"})

        ' Wybiera zamówienia zgrupowane według CustId.
        Dim query1 = From ord In all_orders _
            Order By ord.CustId, ord.OrderId _
            Group ord By ord.CustId Into CustOrders = Group
        Dim root1 As TreeNode = trvResults.Nodes.Add("From ord In all_orders")
        For Each obj In query1
            ' Wyświetla identyfikator klienta.
            Dim cust_node As TreeNode = root1.Nodes.Add("Cust Id: " & obj.CustId)

            ' Lista zamówień klienta.
            For Each ord In obj.CustOrders
                cust_node.Nodes.Add("OrderId: " & ord.OrderId & ", Date: " & ord.OrderDate)
            Next ord

            ' Rozwija poddrzewo klienta.
            cust_node.ExpandAll()
        Next obj

        ' Wybiera klientów i ich zamówienia.
        Dim query2 = From cust In all_customers, ord In all_orders _
            Where cust.CustId = ord.CustId _
            Order By cust.CustId, ord.OrderId _
            Group ord By cust Into CustomerOrders = Group
        Dim root2 As TreeNode = trvResults.Nodes.Add("From cust In all_customers, ord In all_orders")
        For Each obj In query2
            ' Wyświetla informacje o kliencie.
            Dim cust_node As TreeNode = root2.Nodes.Add("Klient: " & obj.cust.ToString())

            ' Lista zamówień klienta.
            For Each ord In obj.CustomerOrders
                cust_node.Nodes.Add("OrderId: " & ord.OrderId & ", Data: " & ord.OrderDate)
            Next ord

            ' Rozwija poddrzewo klienta.
            cust_node.ExpandAll()
        Next obj
    End Sub
End Class

Public Class Person
    Public FirstName As String
    Public LastName As String
    Public CustId As Integer
    Public Overrides Function ToString() As String
        Return FirstName & " " & LastName & " (" & CustId & ")"
    End Function
End Class

Public Class Order
    Public CustId As Integer
    Public OrderDate As Date
    Public OrderId As Integer
    Public Overrides Function ToString() As String
        Return "CustId: " & CustId & ", OrderId: " & OrderId & ", Data: " & OrderDate
    End Function
End Class

Public Class OrderItem
    Public OrderId As Integer
    Public Description As String
    Public Overrides Function ToString() As String
        Return "OrderId: " & OrderId & ", Opis: " & Description
    End Function
End Class
