﻿Public Class Form1
    Private all_customers As New List(Of Customer)
    Private all_orders As New List(Of Order)
    Private all_orderitems As New List(Of OrderItem)

    Private Sub Form1_Load() Handles MyBase.Load
        all_customers.Add(New Customer() With {.Name = "Alice", .CustId = 100, .AccountBalance = 10})
        all_customers.Add(New Customer() With {.Name = "Bob", .CustId = 200, .AccountBalance = 30})
        all_customers.Add(New Customer() With {.Name = "Cindy", .CustId = 300, .AccountBalance = -110})
        all_customers.Add(New Customer() With {.Name = "Dan", .CustId = 400, .AccountBalance = -95})

        all_orders.Add(New Order() With {.CustId = 100, .OrderId = 1001, .OrderDate = #4/1/2008#})
        all_orders.Add(New Order() With {.CustId = 100, .OrderId = 1002, .OrderDate = #4/5/2008#})
        all_orders.Add(New Order() With {.CustId = 200, .OrderId = 1003, .OrderDate = #4/12/2008#})
        all_orders.Add(New Order() With {.CustId = 200, .OrderId = 1004, .OrderDate = #4/19/2008#})
        all_orders.Add(New Order() With {.CustId = 300, .OrderId = 1005, .OrderDate = #4/5/2008#})
        all_orders.Add(New Order() With {.CustId = 400, .OrderId = 1006, .OrderDate = #4/19/2008#})
        all_orders.Add(New Order() With {.CustId = 400, .OrderId = 1007, .OrderDate = #4/5/2008#})

        all_orderitems.Add(New OrderItem() With {.OrderId = 1001, .ItemName = "Pencils, dozen", .UnitPrice = 0.75, .Quantity = 3})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1001, .ItemName = "Notepad", .UnitPrice = 1.15, .Quantity = 12})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1001, .ItemName = "Soda, 12-pack", .UnitPrice = 2.75, .Quantity = 4})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1002, .ItemName = "Candy bar", .UnitPrice = 0.65, .Quantity = 144})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1002, .ItemName = "Laptop computer", .UnitPrice = 1445.93, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1003, .ItemName = "Copy paper, ream", .UnitPrice = 2.18, .Quantity = 10})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1004, .ItemName = "Programming book", .UnitPrice = 27.95, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1005, .ItemName = "Pencils, dozen", .UnitPrice = 0.75, .Quantity = 4})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1005, .ItemName = "Dry erase markers, 5-pack", .UnitPrice = 3.8, .Quantity = 2})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1006, .ItemName = "Fancy mouse", .UnitPrice = 42.57, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1007, .ItemName = "12TB flash drive", .UnitPrice = 107.75, .Quantity = 1})
        all_orderitems.Add(New OrderItem() With {.OrderId = 1007, .ItemName = "Pencils, dozen", .UnitPrice = 0.75, .Quantity = 1})

        Dim txt As String = ""

        ' Zapytanie ze składnią LINQ.
        Dim q1 = _
            From cust In all_customers _
            Where cust.AccountBalance < 0 _
            Order By cust.AccountBalance _
            Select Name = cust.Name, cust.AccountBalance
        txt &= "Składnia LINQ" & vbCrLf
        For Each v In q1
            txt &= Space$(4) & v.Name & " " & FormatCurrency(v.AccountBalance) & vbCrLf
        Next v
        txt &= vbCrLf

        ' Zapytanie z funkcjami LINQ.
        Dim q2 = all_customers. _
            Where(AddressOf OwesMoney). _
            OrderBy(AddressOf OrderByAmount). _
            Select(AddressOf SelectFields)
        txt &= "Funkcje LINQ" & vbCrLf
        For Each v In q2
            txt &= Space$(4) & v.Name & " " & FormatCurrency(v.Balance) & vbCrLf
        Next v
        txt &= vbCrLf

        ' Zapytanie z funkcjami LINQ i lambda.
        Dim q3 = all_customers. _
            Where(Function(c As Customer) c.AccountBalance < 0). _
            OrderBy(Of Decimal)(Function(c As Customer) c.AccountBalance). _
            Select(Of CustInfo)(Function(c As Customer, index As Integer) _
                New CustInfo() With {.Name = c.Name, .Balance = c.AccountBalance} _
            )
        txt &= "LINQ z funkcjami lambda" & vbCrLf
        For Each v In q3
            txt &= Space$(4) & v.Name & " " & FormatCurrency(v.Balance) & vbCrLf
        Next v
        txt &= vbCrLf

        ' Query with LINQ and inline function delegates.
        'Dim owes_money As Func(Of Customer, Boolean) = Function(c As Customer) c.AccountBalance < 0
        'Dim cust_balance As Func(Of Customer, Decimal) = Function(c As Customer) c.AccountBalance
        'Dim new_custinfo As Func(Of Customer, CustInfo) = Function(c As Customer) New CustInfo() With {.Name = c.Name, .Balance = c.AccountBalance}
        'Dim q4 = all_customers. _
        '    Where(owes_money). _
        '    OrderBy(cust_balance). _
        '    Select(new_custinfo)
        Dim owes_money = Function(c As Customer) c.AccountBalance < 0
        Dim cust_balance = Function(c As Customer) c.AccountBalance
        Dim new_custinfo = Function(c As Customer) New CustInfo() With {.Name = c.Name, .Balance = c.AccountBalance}
        Dim q4 = all_customers. _
            Where(owes_money). _
            OrderBy(Of Decimal)(cust_balance). _
            Select(Of CustInfo)(new_custinfo)
        txt &= "LINQ z delegatami funkcji inline" & vbCrLf
        For Each v In q4
            txt &= Space$(4) & v.Name & " " & FormatCurrency(v.Balance) & vbCrLf
        Next v

        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub

    Private Function OwesMoney(ByVal c As Customer) As Boolean
        Return c.AccountBalance < 0
    End Function

    Private Function OrderByAmount(ByVal c As Customer) As Decimal
        Return c.AccountBalance
    End Function

    Private Function SelectFields(ByVal c As Customer, ByVal index As Integer) As CustInfo
        Return New CustInfo() With {.Name = c.Name, .Balance = c.AccountBalance}
    End Function
End Class

Public Class Customer
    Public Name As String
    Public CustId As Integer
    Public AccountBalance As Decimal
End Class

Public Class Order
    Public OrderDate As Date
    Public OrderId As Integer
    Public CustId As Integer
End Class

Public Class OrderItem
    Public OrderId As Integer
    Public ItemName As String
    Public Quantity As Integer
    Public UnitPrice As Decimal
End Class

Public Class CustInfo
    Public Name As String
    Public Balance As Decimal
End Class