﻿Imports System.Runtime.CompilerServices
Imports System.Text.RegularExpressions

Public Class Form1
    Private Sub txt7Digit_Validating() Handles txt7Digit.Validating
        Dim txt As String = txt7Digit.Text
        If txt.IsValidPhoneNumber7digit Then
            errPhone.SetError(txt7Digit, "")
        Else
            errPhone.SetError(txt7Digit, "Niepoprawny siedmiocyfrowy numer telefoniczny")
        End If
    End Sub

    Private Sub txt10Digit_Validating() Handles txt10Digit.Validating
        Dim txt As String = txt10Digit.Text
        If txt.IsValidPhoneNumber10digit Then
            errPhone.SetError(txt10Digit, "")
        Else
            errPhone.SetError(txt10Digit, "Niepoprawny dziesięciocyfrowy numer telefoniczny")
        End If
    End Sub

    Private Sub txtEither_Validating() Handles txtEither.Validating
        Dim txt As String = txtEither.Text
        If txt.IsValidPhoneNumberUS Then
            errPhone.SetError(txtEither, "")
        Else
            errPhone.SetError(txtEither, "Niepoprawny numer telefoniczny")
        End If
    End Sub
End Class

Module StringExtensions
    ' Zwraca True, jeśli String pasuje do wyrażenia regularnego.
    <Extension()> _
    Public Function MatchesRegexp(ByVal the_string As String, ByVal regular_expression As String) As Boolean
        Dim reg_exp As New Regex(regular_expression)
        Return reg_exp.IsMatch(the_string)
    End Function

    ' Zwraca True, jeśli String wygląda jak siedmiocyfrowy numer telefoniczny.
    <Extension()> _
    Public Function IsValidPhoneNumber7digit(ByVal the_string As String) As Boolean
        Return the_string.MatchesRegexp("^[2-9]\d{2}-\d{4}$")
    End Function

    ' Zwraca True, jeśli String wygląda jak dziesięciocyfrowy numer telefoniczny.
    <Extension()> _
    Public Function IsValidPhoneNumber10digit(ByVal the_string As String) As Boolean
        Return the_string.MatchesRegexp("^([2-9]\d{2}-){2}\d{4}$")
    End Function

    ' Zwraca True, jeśli String wygląda jak siedmio- lub dziesięciocyfrowy numer telefoniczny.
    <Extension()> _
    Public Function IsValidPhoneNumberUS(ByVal the_string As String) As Boolean
        Return IsValidPhoneNumber7digit(the_string) OrElse _
               IsValidPhoneNumber10digit(the_string)
    End Function
End Module