﻿Imports System.Windows.Media.Animation

Class Window1
    Private Const BIG_SCALE As Double = 1.75
    Private Const END_SCALE As Double = 1.5

    Private Sub Window1_Loaded() Handles Me.Loaded
        ' Make a style for the buttons.
        Dim br_button As New RadialGradientBrush( _
            Colors.Lime, Colors.Green)
        br_button.Center = New Point(0.5, 0.5)
        br_button.RadiusX = 1
        br_button.RadiusY = 1

        Dim style_button As New Style(GetType(Button))
        style_button.Setters.Add(New Setter(Control.BackgroundProperty, br_button))
        style_button.Setters.Add(New Setter(Control.MarginProperty, New Thickness(2)))

        ' Set the transform origin to (0.5, 0.5).
        style_button.Setters.Add(New Setter(Control.RenderTransformOriginProperty, New Point(0.5, 0.5)))

        ' Set styles for the buttons.
        For Each ctl As Control In grdMain.Children
            If TypeOf ctl Is Button Then
                Dim btn As Button = DirectCast(ctl, Button)
                btn.Style = style_button
                btn.RenderTransform = New ScaleTransform(1, 1)
                AddHandler btn.MouseEnter, AddressOf btn_MouseEnter
                AddHandler btn.MouseLeave, AddressOf btn_MouseLeave
                AddHandler btn.Click, AddressOf btn_Click
            End If
        Next ctl
    End Sub

    ' The mouse moved over the button.
    ' Make it larger.
    Private Sub btn_MouseEnter(ByVal btn As Button, ByVal e As System.Windows.Input.MouseEventArgs)
        ' Get the button's transformation.
        Dim scale_transform As ScaleTransform = _
            DirectCast(btn.RenderTransform, ScaleTransform)

        ' Create a DoubleAnimation that first
        ' makes the button extra big and then
        ' shrinks it to the "normal" big size.
        Dim ani As New DoubleAnimationUsingKeyFrames()
        Dim fr1 As New SplineDoubleKeyFrame(1.0, KeyTime.FromPercent(0.0))
        Dim fr2 As New SplineDoubleKeyFrame(BIG_SCALE, KeyTime.FromPercent(0.5))
        Dim fr3 As New SplineDoubleKeyFrame(END_SCALE, KeyTime.FromPercent(1.0))
        ani.KeyFrames.Add(fr1)
        ani.KeyFrames.Add(fr2)
        ani.KeyFrames.Add(fr3)
        ani.Duration = New Duration(TimeSpan.FromSeconds(0.33))

        ' Create a clock for the animation.
        Dim ani_clock As AnimationClock = ani.CreateClock()
        'Dim ani_clock As AnimationClock = ani.CreateClock()

        ' Associate the clock with the transform's
        ' ScaleX and ScaleY properties.
        scale_transform.ApplyAnimationClock( _
            ScaleTransform.ScaleXProperty, ani_clock)
        scale_transform.ApplyAnimationClock( _
            ScaleTransform.ScaleYProperty, ani_clock)

        ' Pop the button to the top of the stacking order.
        grdMain.Children.Remove(btn)
        grdMain.Children.Add(btn)
    End Sub

    ' The mouse moved off of the button.
    ' Make it smaller.
    Private Sub btn_MouseLeave(ByVal btn As Button, ByVal e As System.Windows.Input.MouseEventArgs)
        ' Get the button's transformation.
        Dim scale_transform As ScaleTransform = _
            DirectCast(btn.RenderTransform, ScaleTransform)

        ' Create a DoubleAnimation.
        Dim ani As New DoubleAnimation(BIG_SCALE, 1, _
            New Duration(TimeSpan.FromSeconds(0.15)))

        ' Create a clock for the animation.
        Dim ani_clock As AnimationClock = ani.CreateClock()

        ' Associate the clock with the transform's
        ' ScaleX and ScaleY properties.
        scale_transform.ApplyAnimationClock( _
            ScaleTransform.ScaleXProperty, ani_clock)
        scale_transform.ApplyAnimationClock( _
            ScaleTransform.ScaleYProperty, ani_clock)
    End Sub

    ' Display the button's content.
    Private Sub btn_Click(ByVal btn As Button, ByVal e As System.Windows.RoutedEventArgs)
        MessageBox.Show(btn.Content.ToString())
    End Sub
End Class
