﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Ustawia minimalną i maksymalną datę.
        calReservation.MinDate = DateAdd(DateInterval.Month, -3, Today)
        calReservation.MaxDate = DateAdd(DateInterval.Month, 3, Today)

        ' Pobiera pierwszy poniedziałek w dozwolonym przedziale.
        Dim mon As DateTime
        mon = calReservation.MinDate
        Select Case mon.DayOfWeek
            Case DayOfWeek.Tuesday
                mon = mon.AddDays(6)
            Case DayOfWeek.Wednesday
                mon = mon.AddDays(5)
            Case DayOfWeek.Thursday
                mon = mon.AddDays(4)
            Case DayOfWeek.Friday
                mon = mon.AddDays(3)
            Case DayOfWeek.Saturday
                mon = mon.AddDays(2)
            Case DayOfWeek.Sunday
                mon = mon.AddDays(1)
        End Select

        ' Tworzy tablicę dozwolonych poniedziałków.
        Dim num_mondays As Integer
        Dim mondays() As DateTime = Nothing
        Do While mon <= calReservation.MaxDate
            num_mondays += 1
            ReDim Preserve mondays(num_mondays - 1)
            mondays(num_mondays - 1) = mon
            calReservation.AddBoldedDate(mon)
            mon = mon.AddDays(7)
        Loop

        ' Wytłuszcza poniedziałki.
        calReservation.BoldedDates = mondays

        ' Ustawia dzisiejszą datę.
        calReservation.TodayDate = Today

        ' Wybiera dzień pojutrze oraz dwa kolejne dni.
        calReservation.SelectionRange = _
            New SelectionRange( _
                DateAdd(DateInterval.Day, 2, Today), _
                DateAdd(DateInterval.Day, 4, Today))
    End Sub

    Private Sub btnOk_Click() Handles btnOk.Click
        Me.Close()
    End Sub

    Private Sub btnCancel_Click() Handles btnCancel.Click
        Me.Close()
    End Sub
End Class
