﻿Imports System.IO
Imports System.Security
Imports System.Security.Cryptography

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        Dim file_path As String = My.Computer.FileSystem.CombinePath(Application.StartupPath, "..\..")
        txtPlaintextFile.Text = file_path & "\plaintext.txt"
        txtPlaintextFile.Select(txtPlaintextFile.Text.Length, 0)
        txtCyphertextFile.Text = file_path & "\cyphertext.dat"
        txtCyphertextFile.Select(txtCyphertextFile.Text.Length, 0)
        txtDecypheredFile.Text = file_path & "\decyphered.txt"
        txtDecypheredFile.Select(txtDecypheredFile.Text.Length, 0)

        ' Wyświetla oryginalny plik.
        txtPlaintext.Text = File.ReadAllText(txtPlaintextFile.Text)
    End Sub

    ' Szyfruje i deszyfruje plik, a wynik zapisuje 
    ' w innym pliku.
    Private Sub CryptFile(ByVal password As String, ByVal in_file As String, ByVal out_file As String, ByVal encrypt As Boolean)
        ' Utworzenie wejściowego i wyjściowego strumienia plikowego.
        Using in_stream As New FileStream(in_file, FileMode.Open, FileAccess.Read)
            Using out_stream As New FileStream(out_file, FileMode.Create, FileAccess.Write)

                ' Utworzenie szyfratora potrójnego algorytmu DES.
                Dim des_provider As New TripleDESCryptoServiceProvider()

                ' Uzyskanie odpowiedniego rozmiaru klucza dla tego szyfratora.
                Dim key_size_bits As Integer = 0
                For i As Integer = 1024 To 1 Step -1
                    If des_provider.ValidKeySize(i) Then
                        key_size_bits = i
                        Exit For
                    End If
                Next i
                Debug.Assert(key_size_bits > 0)

                ' Sprawdza rozmiar bloku tego szyfratora.
                Dim block_size_bits As Integer = des_provider.BlockSize

                ' Generuje klucz i wektor inicjujący.
                Dim key As Byte() = Nothing
                Dim iv As Byte() = Nothing
                Dim salt As Byte() = {&H0, &H0, &H1, &H2, &H3, &H4, &H5, &H6, &HF1, &HF0, &HEE, &H21, &H22, &H45}
                MakeKeyAndIV(password, salt, key_size_bits, block_size_bits, key, iv)

                ' Tworzy szyfrator lub deszyfrator.
                Dim crypto_transform As ICryptoTransform
                If encrypt Then
                    crypto_transform = des_provider.CreateEncryptor(key, iv)
                Else
                    crypto_transform = des_provider.CreateDecryptor(key, iv)
                End If

                ' Przywiązuje strumień szyfrujący do strumienia wyjściowego.
                ' Zamknięcie strumienia crypto_stream czasami powoduje zgłoszenie
                ' wyjątku, jeśli deszyfracja się nie udała
                ' (np. gdy zostanie użyte złe hasło).
                Try
                    Using crypto_stream As New CryptoStream(out_stream, crypto_transform, CryptoStreamMode.Write)
                        ' Szyfruje lub deszyfruje plik.
                        Const BLOCK_SIZE As Integer = 1024
                        Dim buffer(BLOCK_SIZE) As Byte
                        Dim bytes_read As Integer
                        Do
                            ' Czyta porcję bajtów.
                            bytes_read = in_stream.Read(buffer, 0, BLOCK_SIZE)
                            If bytes_read = 0 Then Exit Do

                            ' Zapisuje te bajty w strumieniu CryptoStream.
                            crypto_stream.Write(buffer, 0, bytes_read)
                        Loop

                        ' Zamyka strumienie.
                        crypto_stream.Flush()
                        crypto_stream.Close()
                    End Using ' crypto_stream 
                Catch ex As Exception
                End Try

                crypto_transform.Dispose()
                in_stream.Close()
                out_stream.Close()
            End Using ' out_stream
        End Using ' in_stream
    End Sub

    ' Generuje bajty klucza z hasła.
    Private Sub MakeKeyAndIV(ByVal password As String, ByVal salt() As Byte, ByVal key_size_bits As Integer, ByVal block_size_bits As Integer, ByRef key As Byte(), ByRef iv As Byte())
        Dim derive_bytes As New Rfc2898DeriveBytes( _
            password, salt, 1000)

        key = derive_bytes.GetBytes(key_size_bits \ 8)
        iv = derive_bytes.GetBytes(block_size_bits \ 8)

        ' Debugowanie:
#Const DEBUG_KEY = False
#If DEBUG_KEY Then
            Dim txt As String
            txt = ""
            For i As Integer = 0 To salt.Length - 1
                txt &= salt(i).ToString() & " "
            Next i
            Debug.WriteLine("Sól: " & txt)

            txt = ""
            For i As Integer = 0 To key.Length - 1
                txt &= key(i).ToString() & " "
            Next i
            Debug.WriteLine("Klucz:  " & txt)

            txt = ""
            For i As Integer = 0 To iv.Length - 1
                txt &= iv(i).ToString() & " "
            Next i
            Debug.WriteLine("IV:   " & txt)
            Debug.WriteLine("******")
#End If ' DEBUG_BYTES
    End Sub

    ' Szyfruje plik tekstowy.
    ' Zwróć uwagę na wartości.
    Private Sub btnEncrypt_Click() Handles btnEncrypt.Click
        ' Szyfruje plik.
        CryptFile(txtPassword.Text, txtPlaintextFile.Text, txtCyphertextFile.Text, True)

        ' Wyświetla wynik.
        txtCyphertext.Text = File.ReadAllText(txtCyphertextFile.Text)
    End Sub

    Private Sub btnDecrypt_Click() Handles btnDecrypt.Click
        ' Szyfruje plik.
        CryptFile(txtPassword.Text, txtCyphertextFile.Text, txtDecypheredFile.Text, False)

        ' Wyświetla wynik.
        txtDecyphered.Text = File.ReadAllText(txtDecypheredFile.Text)
    End Sub
End Class
