﻿Imports CrystalDecisions.CrystalReports.Engine

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Manipulate the ReportDocument.
        Using field_object As FieldObject = DirectCast( _
          StudentTestScores1.ReportDefinition.ReportObjects("TestNumber1"),  _
          FieldObject)
            Debug.WriteLine("The " & field_object.Name & _
                " field has data source " & field_object.DataSource.FormulaName)
        End Using

        ' Export the report.
        Dim output_file As String
        output_file = Application.StartupPath & "\scores.xls"
        StudentTestScores1.ExportToDisk( _
            CrystalDecisions.Shared.ExportFormatType.Excel, output_file)

        ' Make GroupFooterSection1 tall and aqua.
        Using section1 As Section = DirectCast( _
          StudentTestScores1.ReportDefinition.Sections("GroupFooterSection1"),  _
          Section)
            section1.Height = 600
            section1.SectionFormat.BackgroundColor = Color.Aqua

            ' Make the average score field red and surrounded by a box.
            Using avg_field_object As FieldObject = DirectCast( _
              StudentTestScores1.ReportDefinition.ReportObjects("AvgofScore1"),  _
              FieldObject)
                avg_field_object.Color = Color.Red
                avg_field_object.Top = (section1.Height - avg_field_object.Height) \ 2
                With avg_field_object.Border
                    .TopLineStyle = CrystalDecisions.Shared.LineStyle.DoubleLine
                    .BottomLineStyle = CrystalDecisions.Shared.LineStyle.DoubleLine
                    .LeftLineStyle = CrystalDecisions.Shared.LineStyle.DoubleLine
                    .RightLineStyle = CrystalDecisions.Shared.LineStyle.DoubleLine
                    .HasDropShadow = True
                End With
            End Using ' avg_field_object
        End Using ' section1
    End Sub
End Class
