﻿Imports System.Drawing.Printing

Public Class Form1
    Private WithEvents m_PrintDocument As PrintDocument

    Private m_PageNumber As Integer

    ' Wyświetla okno dialogowe podglądu wydruku.
    Private Sub btnPrintPreview_Click() Handles btnPrintPreview.Click
        m_PrintDocument = New PrintDocument
        m_PageNumber = 1
        dlgPrintPreview.Document = m_PrintDocument
        dlgPrintPreview.ShowDialog()
    End Sub

    ' Wyświetla okno dialogowe drukowania.
    Private Sub btnPrintDialog_Click() Handles btnPrintDialog.Click
        m_PrintDocument = New PrintDocument
        m_PageNumber = 1
        dlgPrint.Document = m_PrintDocument
        dlgPrint.ShowDialog()
    End Sub

    ' Drukuje.
    Private Sub btnPrintNow_Click() Handles btnPrintNow.Click
        m_PrintDocument = New PrintDocument
        m_PageNumber = 1
        m_PrintDocument.Print()
    End Sub

    ' Drukuje stronę z rombem.
    Private Sub m_PrintDocument_PrintPage(ByVal sender As Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles m_PrintDocument.PrintPage
        Using the_font As New Font("Times New Roman", 300)
            Using string_format As New StringFormat
                string_format.Alignment = StringAlignment.Center
                string_format.LineAlignment = StringAlignment.Center

                e.Graphics.DrawString(m_PageNumber.ToString, _
                    the_font, Brushes.Black, _
                    e.MarginBounds, string_format)
            End Using ' string_format 
        End Using ' the_font

        Using the_pen As New Pen(Color.Black, 10)
            Select Case m_PageNumber
                Case 1  ' Rysuje trójkąt.
                    Dim pts() As Point = { _
                        New Point(e.MarginBounds.Left + e.MarginBounds.Width \ 2, e.MarginBounds.Top), _
                        New Point(e.MarginBounds.Right, e.MarginBounds.Bottom), _
                        New Point(e.MarginBounds.Left, e.MarginBounds.Bottom) _
                    }
                    e.Graphics.DrawPolygon(the_pen, pts)

                Case 2
                    e.Graphics.DrawRectangle(the_pen, e.MarginBounds)

                Case 3
                    Dim pts() As Point = { _
                        New Point(e.MarginBounds.Left + e.MarginBounds.Width \ 2, e.MarginBounds.Top), _
                        New Point(e.MarginBounds.Right, e.MarginBounds.Top + e.MarginBounds.Height \ 2), _
                        New Point(e.MarginBounds.Left + e.MarginBounds.Width \ 2, e.MarginBounds.Bottom), _
                        New Point(e.MarginBounds.Left, e.MarginBounds.Top + e.MarginBounds.Height \ 2) _
                    }
                    e.Graphics.DrawPolygon(the_pen, pts)

            End Select
        End Using ' the_pen 

        m_PageNumber += 1
        e.HasMorePages = m_PageNumber <= 3
    End Sub
End Class
