﻿Imports System.Drawing.Printing
Imports System.Drawing.Drawing2D

Public Class Form1
    ' Wyświetla okno dialogowe podglądu wydruku.
    Private Sub btnPrintPreview_Click() Handles btnPrintPreview.Click
        dlgPrintPreview.ShowDialog()
    End Sub

    ' Wyświetla okno dialogowe drukowania.
    Private Sub btnPrintDialog_Click() Handles btnPrintDialog.Click
        dlgPrint.ShowDialog()
    End Sub

    ' Drukuje.
    Private Sub btnPrintNow_Click() Handles btnPrintNow.Click
        pdocGraph.Print()
    End Sub

    ' Wydruk strony.
    Private Sub pdocGraph_PrintPage(ByVal sender As Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles pdocGraph.PrintPage
        ' Rysuje marginesy. Pamiętaj, aby to zrobić 
        ' przed transformacją obiektu Graphics.
        e.Graphics.DrawRectangle(Pens.Red, e.MarginBounds)

        ' Ta procedura rysuje wykres słupkowy dla 5 wartości
        ' we współrzędnych drukarki z przedziału 
        ' (100, 100) - (600, 400). 
        ' Transformuje obiekt Graphics, aby wynik umieścić na środku.
        Dim picture_rect As New RectangleF(100, 100, 500, 300)
        Dim margin_rect As New RectangleF( _
            e.MarginBounds.X, _
            e.MarginBounds.Y, _
            e.MarginBounds.Width, _
            e.MarginBounds.Height)
        CenterPictureInMargins(e.Graphics, picture_rect, margin_rect)

        ' Rysuje prostokąt wokół wykresu.
        e.Graphics.FillRectangle(Brushes.LightGray, picture_rect)
        e.Graphics.DrawRectangle(Pens.Black, Rectangle.Round(picture_rect))

        ' Rysuje wartości.
        Dim x As Integer = 100
        DrawBar(e.Graphics, x, 200, HatchStyle.BackwardDiagonal)
        DrawBar(e.Graphics, x, 280, HatchStyle.Vertical)
        DrawBar(e.Graphics, x, 240, HatchStyle.ForwardDiagonal)
        DrawBar(e.Graphics, x, 170, HatchStyle.Horizontal)
        DrawBar(e.Graphics, x, 290, HatchStyle.DiagonalCross)

        ' Nie ma więcej stron.
        e.HasMorePages = False
    End Sub

    ' Rysuje słupek w (x, 400)-(x + 100, 400 - hgt).
    Private Sub DrawBar(ByVal gr As Graphics, ByRef x As Integer, ByVal hgt As Integer, ByVal hatch_style As HatchStyle)
        Dim rect As New Rectangle(x, 400 - hgt, 100, hgt)
        Using hatch_brush As New HatchBrush(hatch_style, Color.Black, Color.White)
            gr.FillRectangle(hatch_brush, rect)
        End Using
        gr.DrawRectangle(Pens.Black, rect)
        x += 100
    End Sub

    ' Transformuje obiekt Graphics, aby wyśrodkować prostokąt
    ' picture_bounds w margin_bounds.
    Private Sub CenterPictureInMargins(ByVal gr As Graphics, ByVal picture_bounds As RectangleF, ByVal margin_bounds As RectangleF)
        ' Usuwa wszelkie transformacje.
        gr.ResetTransform()

        ' Stosuje transformację.
        Dim dx As Single = _
            margin_bounds.Left - picture_bounds.Left + _
            (margin_bounds.Width - picture_bounds.Width) / 2
        Dim dy As Single = _
            margin_bounds.Top - picture_bounds.Top + _
            (margin_bounds.Height - picture_bounds.Height) / 2
        gr.TranslateTransform(dx, dy)
    End Sub
End Class
