﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        Me.SetStyle(ControlStyles.AllPaintingInWmPaint Or ControlStyles.ResizeRedraw, True)
        Me.UpdateStyles()
    End Sub

    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        e.Graphics.TextRenderingHint = System.Drawing.Text.TextRenderingHint.AntiAliasGridFit

        Dim txt As String = "Mgfi"
        Dim layout_rect As New RectangleF(0, 0, _
            Me.ClientSize.Width \ 3, Me.ClientSize.Height)
        Using string_format As New StringFormat
            string_format.LineAlignment = StringAlignment.Center
            string_format.Alignment = StringAlignment.Center

            Using the_font As New Font("Times New Roman", 80, FontStyle.Bold, GraphicsUnit.Pixel)
                MeasureCharacters(e.Graphics, the_font, txt, layout_rect, string_format)
            End Using

            layout_rect.X += Me.ClientSize.Width \ 3
            Using the_font As New Font("Comic Sans MS", 80, FontStyle.Bold, GraphicsUnit.Pixel)
                MeasureCharacters(e.Graphics, the_font, txt, layout_rect, string_format)
            End Using

            layout_rect.X += Me.ClientSize.Width \ 3
            Using the_font As New Font("Courier New", 80, FontStyle.Bold, GraphicsUnit.Pixel)
                MeasureCharacters(e.Graphics, the_font, txt, layout_rect, string_format)
            End Using
        End Using ' string_format 
    End Sub

    ' Rysuje metrykę fontu.
    Public Sub MeasureCharacters(ByVal gr As Graphics, ByVal the_font As Font, ByVal txt As String, ByVal layout_rect As RectangleF, ByVal string_format As StringFormat)
        ' Definiuje tablicę obiektów CharacterRange,
        ' po jednym dla każdego znaku.
        Dim character_ranges(txt.Length - 1) As CharacterRange
        For i As Integer = 0 To txt.Length - 1
            character_ranges(i) = New CharacterRange(i, 1)
        Next i

        ' Ustawia przedziały w obiekcie StringFormat.
        string_format.SetMeasurableCharacterRanges(character_ranges)

        ' Pobiera regiony zakresów znaków.
        Dim character_regions() As Region = _
            gr.MeasureCharacterRanges(txt, _
            the_font, layout_rect, string_format)

        ' Pobiera wydłużenie górne fontu.
        Dim em_height As Integer = the_font.FontFamily.GetEmHeight(FontStyle.Bold)
        Dim em_height_pix As Single = the_font.Size
        Dim design_to_pixels As Single = the_font.Size / em_height
        Dim ascent As Integer = the_font.FontFamily.GetCellAscent(FontStyle.Bold)
        Dim ascent_pix As Single = ascent * design_to_pixels
        Dim descent As Integer = the_font.FontFamily.GetCellDescent(FontStyle.Bold)
        Dim descent_pix As Single = descent * design_to_pixels
        Dim cell_height_pix As Single = ascent_pix + descent_pix
        Dim internal_leading_pix As Single = cell_height_pix - em_height_pix
        Dim line_spacing As Integer = the_font.FontFamily.GetLineSpacing(FontStyle.Bold)
        Dim line_spacing_pix As Single = line_spacing * design_to_pixels
        Dim external_leading_pix As Single = line_spacing_pix - cell_height_pix

        ' Rysuje granice każdego regionu.
        For Each rgn As Region In character_regions
            ' Konwersja regionu na prostokąt.
            Dim character_bounds As RectangleF = rgn.GetBounds(gr)
            Dim character_rect As Rectangle = _
                Rectangle.Round(character_bounds)

            ' Rysuje granice.
            gr.DrawRectangle(Pens.Black, character_rect)

            ' Rysuje leading wewnętrzny.
            gr.DrawLine(Pens.Black, _
                character_rect.X - 3, _
                character_rect.Y + internal_leading_pix, _
                character_rect.Right + 3, _
                character_rect.Y + internal_leading_pix)

            ' Rysuje wydłużenie górne.
            gr.DrawLine(Pens.Black, _
                character_rect.X - 8, _
                character_rect.Y + ascent_pix, _
                character_rect.Right + 8, _
                character_rect.Y + ascent_pix)

            ' Rysuje wydłużenie dolne.
            gr.DrawLine(Pens.Black, _
                character_rect.X - 12, _
                character_rect.Y + ascent_pix + descent_pix, _
                character_rect.Right + 12, _
                character_rect.Y + ascent_pix + descent_pix)

            ' Rysuje leading zewnętrzny.
            gr.FillRectangle(Brushes.Red, _
                character_rect.X, _
                character_rect.Y + ascent_pix + descent_pix, _
                character_rect.Width, _
                external_leading_pix)
        Next rgn

        ' Rysuje tekst.
        gr.DrawString(txt, the_font, Brushes.Black, _
            layout_rect, string_format)
    End Sub
End Class
