﻿Imports System.Drawing.Drawing2D

Public Class Form1
    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        Dim x As Integer = 25
        Dim y As Integer = 25

        e.Graphics.SmoothingMode = SmoothingMode.AntiAlias

        Dim alignments As Array = PenAlignment.GetValues(GetType(PenAlignment))
        For Each align As PenAlignment In alignments
            DrawSample(e.Graphics, x, y, align)
        Next align
    End Sub

    Private Sub DrawSample(ByVal gr As Graphics, ByRef x As Integer, ByRef y As Integer, ByVal pen_alignment As PenAlignment)
        Const WID As Integer = 100
        Const DX As Integer = 30
        Const DY As Integer = 30
        Using the_pen As New Pen(Color.LightGray, 20)
            Dim rect As New Rectangle(x, y, WID, WID)

            the_pen.Alignment = pen_alignment
            If False Then
                Dim pts() As Point = { _
                    New Point(x, y), _
                    New Point(x + WID \ 2, y), _
                    New Point(x + WID, y + WID), _
                    New Point(x, y + WID \ 2) _
                }
                'gr.DrawLines(the_pen, pts)
                'gr.DrawLines(Pens.Black, pts)

                'gr.DrawClosedCurve(the_pen, pts)
                'gr.DrawClosedCurve(Pens.Black, pts)

                gr.DrawArc(the_pen, x, y, WID, WID, 0, 180)
                gr.DrawArc(Pens.Black, x, y, WID, WID, 0, 180)
            Else
                gr.DrawEllipse(the_pen, rect)
                gr.DrawEllipse(Pens.Black, rect)

                'gr.DrawLine(the_pen, x + WID + 30, y, x + WID + 30, y + WID)
                'gr.DrawLine(Pens.Black, x + WID + 30, y, x + WID + 30, y + WID)
            End If

            Dim string_format As New StringFormat
            string_format.Alignment = StringAlignment.Center
            string_format.LineAlignment = StringAlignment.Center
            gr.DrawString(pen_alignment.ToString, Me.Font, _
                Brushes.Black, rect, string_format)

            x += WID + DX
            If x > Me.ClientSize.Width - WID Then
                x = 25
                y += WID + DY
            End If
        End Using
    End Sub
End Class
