﻿' Słownik wiążący z każdym kluczem 
' jedną parę wartości.
Public Class PairDictionary(Of KeyType, DataType1, DataType2)
    ' Struktura do przechowywania par danych.
    Private Structure DataPair
        Public Data1 As DataType1
        Public Data2 As DataType2
        Public Sub New(ByVal data_value1 As DataType1, ByVal data_value2 As DataType2)
            Data1 = data_value1
            Data2 = data_value2
        End Sub
    End Structure

    ' Słownik do przechowywania par danych.
    Private m_Dictionary As New Dictionary(Of KeyType, DataPair)

    ' Zwraca liczbę par danych.
    Public ReadOnly Property Count() As Integer
        Get
            Return m_Dictionary.Count
        End Get
    End Property

    ' Dodaje klucz i parę danych.
    Public Sub Add(ByVal key As KeyType, ByVal data_value1 As DataType1, ByVal data_value2 As DataType2)
        m_Dictionary.Add(key, New DataPair(data_value1, data_value2))
    End Sub

    ' Usuwa wszystkie dane.
    Public Sub Clear()
        m_Dictionary.Clear()
    End Sub

    ' Zwraca True, jeśli PairDictionary zawiera ten klucz.
    Public Function ContainsKey(ByVal key As KeyType) As Boolean
        Return m_Dictionary.ContainsKey(key)
    End Function

    ' Zwraca parę danych.
    Public Sub GetItem(ByVal key As KeyType, ByRef data_value1 As DataType1, ByRef data_value2 As DataType2)
        Dim data_pair As DataPair = m_Dictionary.Item(key)
        data_value1 = data_pair.Data1
        data_value2 = data_pair.Data2
    End Sub

    ' Ustawia parę danych.
    Public Sub SetItem(ByVal key As KeyType, ByVal data_value1 As DataType1, ByVal data_value2 As DataType2)
        m_Dictionary.Item(key) = _
            New DataPair(data_value1, data_value2)
    End Sub

    ' Zwraca kolekcję kluczy.
    Public ReadOnly Property Keys() As System.Collections.ICollection
        Get
            Return m_Dictionary.Keys()
        End Get
    End Property

    ' Usuwa wybraną pozycję.
    Public Sub Remove(ByVal key As KeyType)
        m_Dictionary.Remove(key)
    End Sub
End Class
