﻿Imports System.ComponentModel
Imports System.Collections.Generic

Public Class Form1
    Private the_items As New MostRecentList(Of DataItem)(4)

    Private Sub Form1_Load() Handles MyBase.Load
        the_items.Add(New DataItem() With {.Text = "Jabłko"})
        the_items.Add(New DataItem() With {.Text = "Banan"})
        the_items.Add(New DataItem() With {.Text = "Wiśnia"})
        the_items.Add(New DataItem() With {.Text = "Daktyl"})
        the_items.Add(New DataItem() With {.Text = "Banan"})
        the_items.Add(New DataItem() With {.Text = "Figa"})
        ShowItems()
    End Sub

    ' Wyświetla elementy na liście.
    Private Sub ShowItems()
        Dim txt As String = ""
        For i As Integer = 0 To the_items.Count - 1
            txt &= the_items.Item(i).Text & vbCrLf
        Next i
        lblItems.Text = txt
    End Sub

    ' Zmienia maksymalną liczbę elementów na liście.
    Private Sub txtMaxItems_TextChanged() Handles txtMaxItems.TextChanged
        Try
            Dim max_items As Integer = Integer.Parse(txtMaxItems.Text)
            If max_items > 0 And max_items < 10 Then
                the_items.MaxItems = max_items
                ShowItems()
            End If
        Catch ex As Exception
        End Try
    End Sub

    ' Dodaje element do listy.
    Private Sub btnAdd_Click() Handles btnAdd.Click
        Dim new_data As New DataItem
        new_data.Text = txtNewItem.Text
        the_items.Add(new_data)
        txtNewItem.Text = ""
        txtNewItem.Focus()
        ShowItems()
    End Sub

    ' Usuwa element z listy.
    Private Sub btnRemove_Click() Handles btnRemove.Click
        Dim target_data As New DataItem
        target_data.Text = txtNewItem.Text

        the_items.Remove(target_data)
        txtNewItem.Text = ""
        txtNewItem.Focus()
        ShowItems()
    End Sub
End Class
