﻿Public Class Employee
    ' Własność FirstName.
    Private m_FirstName As String
    Public Property FirstName() As String
        Get
            Return m_FirstName
        End Get
        Set(ByVal value As String)
            m_FirstName = value
            RaiseEvent NameChanged(m_FirstName & " " & m_LastName)
        End Set
    End Property

    ' Własność LastName.
    Private m_LastName As String
    Public Property LastName() As String
        Get
            Return m_LastName
        End Get
        Set(ByVal value As String)
            m_LastName = value
            RaiseEvent NameChanged(m_FirstName & " " & m_LastName)
        End Set
    End Property

    ' Lista do przechowywania delegatów procedur obsługi zdarzeń.
    Private m_EventDelegates As New ArrayList

    ' Definiuje sygnaturę procedury obsługi zdarzeń.
    Public Delegate Sub NameChangedDelegate(ByVal new_name As String)

    ' Definicja niestandardowego zdarzenia NameChanged.
    Public Custom Event NameChanged As NameChangedDelegate
        AddHandler(ByVal value As NameChangedDelegate)
            Debug.WriteLine("AddHandler")
            m_EventDelegates.Add(value)
        End AddHandler

        RemoveHandler(ByVal value As NameChangedDelegate)
            Debug.WriteLine("RemoveHandler")
            m_EventDelegates.Remove(value)
        End RemoveHandler

        RaiseEvent(ByVal new_name As String)
            Debug.WriteLine("RaiseEvent (" & new_name & ")")
            For Each a_delegate As NameChangedDelegate In m_EventDelegates
                a_delegate(new_name.Replace(" ", "+"))
            Next a_delegate
        End RaiseEvent
    End Event
End Class
