﻿Option Explicit On
Option Infer On
Option Strict On

Imports System.Xml

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Tworzenie danych.
        Dim all_customers As New List(Of Customer)
        all_customers.Add(New Customer() With {.FirstName = "Ann", .LastName = "Archer", .Balance = 100D})
        all_customers.Add(New Customer() With {.FirstName = "Ben", .LastName = "Best", .Balance = -24.54D})
        all_customers.Add(New Customer() With {.FirstName = "Carly", .LastName = "Cant", .Balance = 62.4D})
        all_customers.Add(New Customer() With {.FirstName = "Dan", .LastName = "Dump", .Balance = 117.95D})
        all_customers.Add(New Customer() With {.FirstName = "Edna", .LastName = "Ever", .Balance = -192.75D})
        all_customers.Add(New Customer() With {.FirstName = "Frank", .LastName = "Fix", .Balance = -150.9D})

        Dim txt As String = ""

        ' Wybiera wszystkich klientów.
        'Dim x_all As XElement = _
        '    <AllCustomers>
        '        <%= From cust In all_customers _
        '            Select New XElement("Customer", _
        '            New XAttribute("FirstName", cust.FirstName), _
        '            New XAttribute("LastName", cust.LastName), _
        '            New XText(cust.Balance.ToString("0.00"))) _
        '        %>
        '    </AllCustomers>

        ' Inny format.
        Dim x_all As XElement = _
            <AllCustomers>
                <%= From cust In all_customers _
                    Select <Customer
                               FirstName=<%= cust.FirstName %>
                               LastName=<%= cust.LastName %>
                               >
                               <%= cust.Balance.ToString("0.00") %>
                           </Customer> _
                %>
            </AllCustomers>
        txt &= "LINQ All Customers:" & vbCrLf & x_all.ToString() & vbCrLf & vbCrLf

        ' Separate customers with positive and negative balances.
        Dim separated As XElement = _
            <AllCustomers>
                <PositiveBalances>
                    <%= From cust In x_all.Descendants("Customer") _
                        Where CDec(cust.Value) >= 0 _
                        Order By CDec(cust.Value) Descending _
                        Select New XElement("Customer", _
                        New XAttribute("FirstName", CStr(cust.Attribute("FirstName"))), _
                        New XAttribute("LastName", CStr(cust.Attribute("LastName"))), _
                        New XText(cust.Value)) _
                    %>
                </PositiveBalances>
                <NegativeBalances>
                    <%= From cust In x_all.Descendants("Customer") _
                        Where CDec(cust.Value) < 0 _
                        Order By CDec(cust.Value) Descending _
                        Select New XElement("Customer", _
                        New XAttribute("FirstName", CStr(cust.Attribute("FirstName"))), _
                        New XAttribute("LastName", CStr(cust.Attribute("LastName"))), _
                        New XText(cust.Value)) _
                    %>
                </NegativeBalances>
            </AllCustomers>
        txt &= "LINQ Grouped Customers:" & vbCrLf & separated.ToString() & vbCrLf & vbCrLf

        ' Wybiera wszystkich klientów.
        txt &= "Wszyscy klienci:" & vbCrLf
        Dim select_all = From cust In x_all.Descendants("Customer") _
            Order By CDec(cust.Value) _
            Select FName = cust.Attribute("FirstName").Value, _
                   LName = cust.Attribute("LastName").Value, _
                   Balance = cust.Value
        For Each c In select_all
            txt &= Space$(4) & c.FName & " " & c.LName & vbTab & FormatCurrency(c.Balance) & vbCrLf
        Next c
        txt &= vbCrLf

        ' Wybiera tylko tych, którzy mają ujemne salda.
        txt &= "Klienci z ujemnymi saldami:" & vbCrLf
        Dim x_neg = From cust In x_all.Descendants("Customer") _
            Where CDec(cust.Value) < 0 _
            Select FName = cust.Attribute("FirstName").Value, _
                   LName = cust.Attribute("LastName").Value, _
                   Balance = cust.Value
        For Each c In x_neg
            txt &= Space$(4) & c.FName & " " & c.LName & vbTab & FormatCurrency(c.Balance) & vbCrLf
        Next c
        txt &= vbCrLf


        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub
End Class

Public Class Customer
    Public FirstName As String
    Public LastName As String
    Public Balance As Decimal
    Public Overrides Function ToString() As String
        Return FirstName & " " & LastName & " (" & Balance & ")"
    End Function
End Class
