﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Tworzenie danych.
        Dim all_customers As New List(Of Person)
        all_customers.Add(New Person() With {.FirstName = "Ann", .LastName = "Archer", .CustId = 5})
        all_customers.Add(New Person() With {.FirstName = "Ben", .LastName = "Best", .CustId = 2})
        all_customers.Add(New Person() With {.FirstName = "Carly", .LastName = "Cant", .CustId = 6})
        all_customers.Add(New Person() With {.FirstName = "Dan", .LastName = "Dump", .CustId = 1})
        all_customers.Add(New Person() With {.FirstName = "Edna", .LastName = "Ever", .CustId = 3})
        all_customers.Add(New Person() With {.FirstName = "Frank", .LastName = "Fix", .CustId = 4})

        Dim all_orders As New List(Of Order)
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 103, .OrderDate = #4/12/2008#})
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 101, .OrderDate = #4/4/2008#})
        all_orders.Add(New Order() With {.CustId = 3, .OrderId = 102, .OrderDate = #4/7/2008#})
        all_orders.Add(New Order() With {.CustId = 1, .OrderId = 104, .OrderDate = #4/15/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 106, .OrderDate = #4/23/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 100, .OrderDate = #4/7/2008#})
        all_orders.Add(New Order() With {.CustId = 2, .OrderId = 105, .OrderDate = #4/19/2008#})
        all_orders.Add(New Order() With {.CustId = 3, .OrderId = 107, .OrderDate = #4/29/2008#})
        all_orders.Add(New Order() With {.CustId = 4, .OrderId = 108, .OrderDate = #5/2/2008#})
        all_orders.Add(New Order() With {.CustId = 5, .OrderId = 109, .OrderDate = #5/11/2008#})
        all_orders.Add(New Order() With {.CustId = 6, .OrderId = 110, .OrderDate = #5/15/2008#})

        Dim all_order_items As New List(Of OrderItem)
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 12})
        all_order_items.Add(New OrderItem() With {.OrderId = 100, .Description = "Banana", .UnitPrice = 2.2, .Quantity = 1})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Cookie", .UnitPrice = 1.25, .Quantity = 144})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 12})
        all_order_items.Add(New OrderItem() With {.OrderId = 101, .Description = "Soda", .UnitPrice = 0.75, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Paper, ream", .UnitPrice = 3.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 2})
        all_order_items.Add(New OrderItem() With {.OrderId = 102, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Apple", .UnitPrice = 0.75, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Bean, Can", .UnitPrice = 1.15, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Cookie", .UnitPrice = 1.25, .Quantity = 3})
        all_order_items.Add(New OrderItem() With {.OrderId = 103, .Description = "Pencil, dozen", .UnitPrice = 1.35, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 2})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Flamethrower", .UnitPrice = 1750, .Quantity = 1})
        all_order_items.Add(New OrderItem() With {.OrderId = 104, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 105, .Description = "Paper, ream", .UnitPrice = 3.5, .Quantity = 10})
        all_order_items.Add(New OrderItem() With {.OrderId = 106, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 2})
        all_order_items.Add(New OrderItem() With {.OrderId = 107, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 1})
        all_order_items.Add(New OrderItem() With {.OrderId = 108, .Description = "Cookie", .UnitPrice = 1.25, .Quantity = 3})
        all_order_items.Add(New OrderItem() With {.OrderId = 108, .Description = "Pencil, dozen", .UnitPrice = 1.35, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Notebook", .UnitPrice = 2.5, .Quantity = 6})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Pen, dozen", .UnitPrice = 2.65, .Quantity = 12})
        all_order_items.Add(New OrderItem() With {.OrderId = 109, .Description = "Soda", .UnitPrice = 0.75, .Quantity = 4})
        all_order_items.Add(New OrderItem() With {.OrderId = 110, .Description = "Paper, ream", .UnitPrice = 3.5, .Quantity = 6})

        Dim txt As String = ""

        txt &= "FirstOrDefault" & vbCrLf
        Dim rod_query = From cust In all_customers _
            Where cust.FirstName = "Rod" AndAlso cust.LastName = "Stephens"
        Dim rod As Person = rod_query.FirstOrDefault()
        txt &= Space$(4) & "Rod: " & If(rod Is Nothing, "(Nothing)", rod.ToString()) & vbCrLf

        Dim ann_query = From cust In all_customers
        Dim ann As Person = ann_query.FirstOrDefault( _
            Function(per As Person) per.FirstName = "Ann" AndAlso per.LastName = "Archer")
        txt &= Space$(4) & "Ann: " & If(ann Is Nothing, "(Nothing)", ann.ToString()) & vbCrLf

        txt &= vbCrLf & "SingleOrDefault" & vbCrLf
        Dim max_query = From cust In all_customers _
            Where cust.FirstName = "Max" AndAlso cust.LastName = "Marx"
        Dim max As Person = max_query.SingleOrDefault()
        txt &= Space$(4) & "Max: " & If(max Is Nothing, "(Nothing)", max.ToString()) & vbCrLf

        Dim ben_query = From cust In all_customers
        Dim ben As Person = ben_query.SingleOrDefault( _
            Function(per As Person) per.FirstName = "Ben" AndAlso per.LastName = "Best")
        txt &= Space$(4) & "Ben: " & If(ben Is Nothing, "(Nothing)", ben.ToString()) & vbCrLf

        Try
            Dim all_query = From cust In all_customers
            Dim all As Person = all_query.SingleOrDefault()
            txt &= Space$(4) & "All: " & If(all Is Nothing, "(Nothing)", all.ToString()) & vbCrLf
        Catch ex As Exception
            txt &= Space$(4) & "All: " & ex.Message & vbCrLf
        End Try

        txt &= vbCrLf & "ElementAt" & vbCrLf
        Dim per2 As Person = all_customers.ElementAt(2)
        txt &= Space$(4) & "Per2: " & If(per2 Is Nothing, "(Nothing)", per2.ToString()) & vbCrLf

        Try
            Dim per20 As Person = all_customers.ElementAt(20)
            txt &= Space$(4) & "Per20: " & If(per20 Is Nothing, "(Nothing)", per20.ToString()) & vbCrLf
        Catch ex As Exception
            txt &= Space$(4) & "Per20: " & ex.Message & vbCrLf
        End Try

        txt &= vbCrLf & "ElementAtOrDefault" & vbCrLf
        Dim per2a As Person = all_customers.ElementAtOrDefault(2)
        txt &= Space$(4) & "Per2a: " & If(per2a Is Nothing, "(Nothing)", per2a.ToString()) & vbCrLf

        Dim per20a As Person = all_customers.ElementAtOrDefault(20)
        txt &= Space$(4) & "Per20a: " & If(per20a Is Nothing, "(Nothing)", per20a.ToString()) & vbCrLf

        txt &= vbCrLf & "DefaultIfEmpty all" & vbCrLf
        Dim all_custs = all_customers.DefaultIfEmpty()
        For Each per In all_custs
            txt &= Space$(4) & per.ToString() & vbCrLf
        Next per

        txt &= vbCrLf & "DefaultIfEmpty none" & vbCrLf
        Dim no_custs = max_query.DefaultIfEmpty()
        For Each per In no_custs
            txt &= Space$(4) & If(per Is Nothing, "(Nothing)", per.ToString()) & vbCrLf
        Next per

        txt &= vbCrLf & "DefaultIfEmpty Max" & vbCrLf
        Dim max_custs = max_query.DefaultIfEmpty(New Person With {.FirstName = "Max", .LastName = "Marx"})
        For Each per In max_custs
            txt &= Space$(4) & per.ToString() & vbCrLf
        Next per

        Dim order100query = From ord In all_order_items _
            Where ord.OrderId = 100
        Dim all_sum = order100query.Sum(Function(oi As OrderItem) oi.UnitPrice * oi.Quantity)
        txt &= vbCrLf & "Order 100 total: " & FormatCurrency(all_sum) & vbCrLf

        Dim agg1_sum = order100query.Aggregate(Of Decimal)(0, _
            Function(total As Decimal, oi As OrderItem) total + oi.UnitPrice * oi.Quantity)
        txt &= "Custom Sum: " & FormatCurrency(agg1_sum) & vbCrLf

        Dim agg2_sum = order100query.Aggregate(Of Decimal)(-10, _
            Function(total As Decimal, oi As OrderItem) total + oi.UnitPrice * oi.Quantity)
        txt &= "$10 discount: " & FormatCurrency(agg2_sum) & vbCrLf

        Dim all_q = From cust In all_customers
        txt &= vbCrLf & "Sequences equal: " & all_q.SequenceEqual(all_customers) & vbCrLf
        txt &= "Sequences equal: " & max_query.SequenceEqual(all_customers) & vbCrLf

        Dim empty_query = Enumerable.Empty(Of Person)()
        txt &= vbCrLf & "Empty result contains " & empty_query.Count & " items" & vbCrLf
        Dim range_query = Enumerable.Range(1, 10)
        txt &= "Range(1, 10) contains " & range_query.Count & " items" & vbCrLf
        Dim repeat_query = Enumerable.Repeat(Of Person)(ann, 3)
        txt &= "Repeat(ann, 3) contains " & repeat_query.Count & " items" & vbCrLf

        txt &= vbCrLf & "all_customer contains ann: " & all_customers.Contains(ann) & vbCrLf
        txt &= "all_customer contains max: " & all_customers.Contains(max) & vbCrLf

        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub
End Class


Public Class Person
    Public FirstName As String
    Public LastName As String
    Public CustId As Integer
    Public Overrides Function ToString() As String
        Return FirstName & " " & LastName & " (" & CustId & ")"
    End Function
End Class

Public Class Order
    Public CustId As Integer
    Public OrderDate As Date
    Public OrderId As Integer
    Public Overrides Function ToString() As String
        Return "CustId: " & CustId & ", OrderId: " & OrderId & ", Date: " & OrderDate
    End Function
End Class

Public Class OrderItem
    Public OrderId As Integer
    Public Description As String
    Public UnitPrice As Decimal
    Public Quantity As Integer
    Public Overrides Function ToString() As String
        Return "OrderId: " & OrderId & ", Description: " & Description
    End Function
End Class
