﻿Class Window1 
    Private Sub Window1_Loaded() Handles MyBase.Loaded
        ' Make a grid.
        Dim grd As New Grid()
        grd.Width = btnGrid.Width - 10
        grd.Height = btnGrid.Height - 10

        ' Add rows and columns.
        AddRow(grd, New GridLength(33, GridUnitType.Star))
        AddRow(grd, New GridLength(33, GridUnitType.Star))
        AddRow(grd, New GridLength(33, GridUnitType.Star))
        AddCol(grd, New GridLength(33, GridUnitType.Star))
        AddCol(grd, New GridLength(33, GridUnitType.Star))
        AddCol(grd, New GridLength(33, GridUnitType.Star))

        ' Put things inside the grid.
        Dim lbl1 As New Label()
        lbl1.Content = "UL"
        lbl1.HorizontalAlignment = Windows.HorizontalAlignment.Left
        lbl1.VerticalAlignment = Windows.VerticalAlignment.Top
        lbl1.SetValue(Grid.RowProperty, 0)
        lbl1.SetValue(Grid.ColumnProperty, 0)
        grd.Children.Add(lbl1)

        Dim lbl2 As New Label()
        lbl2.Content = "In the Middle"
        lbl2.HorizontalAlignment = Windows.HorizontalAlignment.Center
        lbl2.VerticalAlignment = Windows.VerticalAlignment.Center
        lbl2.SetValue(Grid.RowProperty, 1)
        lbl2.SetValue(Grid.ColumnProperty, 0)
        lbl2.SetValue(Grid.ColumnSpanProperty, 3)
        grd.Children.Add(lbl2)

        Dim lbl3 As New Label()
        lbl3.Content = "LR"
        lbl3.HorizontalAlignment = Windows.HorizontalAlignment.Right
        lbl3.VerticalAlignment = Windows.VerticalAlignment.Bottom
        lbl3.SetValue(Grid.RowProperty, 2)
        lbl3.SetValue(Grid.ColumnProperty, 2)
        grd.Children.Add(lbl3)

        ' Put the grid inside the button.
        btnGrid.Content = grd
    End Sub

    ' Add a row of the indicated height to the grid.
    Private Sub AddRow(ByVal my_grid As System.Windows.Controls.Grid, _
     ByVal height As GridLength)
        Dim row_def As New RowDefinition()
        row_def.Height = height
        my_grid.RowDefinitions.Add(row_def)
    End Sub

    ' Add a column of the indicated width to the grid.
    Private Sub AddCol(ByVal my_grid As System.Windows.Controls.Grid, _
     ByVal width As GridLength)
        Dim col_def As New ColumnDefinition()
        col_def.Width = width

        my_grid.ColumnDefinitions.Add(col_def)
    End Sub

    Private Sub btnGrid_Click() Handles btnGrid.Click
        MessageBox.Show("Clicked!", "Clicked", _
            MessageBoxButton.OK, _
            MessageBoxImage.Information)
    End Sub
End Class
