﻿Imports System.ComponentModel
Imports System.Web.UI
<ControlBuilder(GetType(BookCounterBuilder)), ParseChildren(False)> _
Public Class BookInquiryList _
            : Inherits System.Web.UI.WebControls.WebControl _
            : Implements INamingContainer

    Protected Overrides Sub Render(ByVal output As HtmlTextWriter)

        Dim totalClicks As Integer = 0

      ' wyświetlenie nagłówka
        output.Write("<Table border='1' width='90%' cellpadding='1'" & _
           "cellspacing='1' align = 'center' >")
        output.Write("<TR><TD colspan = '2' align='center'>")
      output.Write("<B> Zamówienia </B></TD></TR>")

      ' jeśli nie ma żadnych kontrolek, wyświetlenie domyślnego komunikatu
        If Controls.Count = 0 Then
            output.Write("<TR><TD colspan='2' align='center'>")
         output.Write("<B> Brak książek na liście </B></TD></TR>")
         ' w przeciwnym razie wyświetlenie wszystkich kontrolek
        Else
         ' iteracja przez kolekcję kontrolek
         ' i wyświetlenie nazwy książki dla każdej kontrolki
         ' następnie nakazanie każdej kontrolce, by sama się wygenerowała
         'Dim current As BookCounter

            For Each current As BookCounter In Controls
                totalClicks += current.Count
                output.Write("<TR><TD align='left'>" & _
                   current.BookName + "</TD>")
                output.RenderBeginTag("TD")
                current.RenderControl(output)
                output.RenderEndTag()            ' end td
                output.Write("</tr>")
            Next
            Dim strTotalInquiries As String = totalClicks.ToString
         output.Write("<TR><TD colspan='2' align='center'> " & _
            " Razem zamówień: " & _
            CStr(strTotalInquiries) & "</TD></TR>")
        End If
        output.Write("</TABLE>")
    End Sub



End Class

Class BookCounterBuilder
    Inherits ControlBuilder

    Public Overrides Function GetChildControlType( _
          ByVal tagName As String, ByVal attributes As IDictionary) As Type
        If tagName = "BookCounter" Then
            Dim theBookCounter As BookCounter
            Return theBookCounter.GetType
        Else
            Return Nothing
        End If
    End Function

    Public Overrides Sub AppendLiteralString(ByVal s As String)
    End Sub

End Class