Public Class RandomNumberGeneratorInput

    Public m_NumberOfDigits As Integer
    Public m_MinValue As Integer
    Public m_MaxValue As Integer

    Public Property NumberOfDigits() As Integer
        Get
            Return m_NumberOfDigits
        End Get
        Set(ByVal value As Integer)
            m_NumberOfDigits = value
        End Set
    End Property
    Public Property MinValue() As Integer
        Get
            Return m_MinValue
        End Get
        Set(ByVal value As Integer)
            If value < 0 Or value > 9 Then Throw New InvalidOperationException()
            m_MinValue = value
        End Set
    End Property
    Public Property MaxValue() As Integer
        Get
            Return m_MaxValue
        End Get
        Set(ByVal value As Integer)
            If value < 0 Or value > 9 Then Throw New InvalidOperationException()
            m_MaxValue = value
        End Set
    End Property

    Public Sub New(ByVal numberOfDigits As Integer, ByVal minValue As Integer, ByVal maxValue As Integer)
        Me.NumberOfDigits = numberOfDigits
        Me.MinValue = minValue
        Me.MaxValue = maxValue
    End Sub

End Class
