Imports System.IO
Imports System.Xml

Public Class Form1

    Private Sub cmdCreate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdCreate.Click

        Dim fs As FileStream = New FileStream(txtFile.Text, FileMode.Create)
        Dim w As XmlTextWriter = New XmlTextWriter(fs, Nothing)

        w.WriteStartDocument()

        w.WriteStartElement("mydocument")
        w.WriteAttributeString("name", "", "MatthewDescription") ' Opis Mateusza
        w.WriteComment("This is the comment, etc.") ' to jest komentarz

        w.WriteStartElement("person")   ' osoba
        w.WriteStartElement("name")     ' imi
        w.WriteString("Matthew")
        w.WriteEndElement()
        w.WriteStartElement("phone")
        w.WriteString("555-5555")
        w.WriteEndElement()
        w.WriteEndElement()

        ' Could add more person elements here ... - tu mona doda wicej osb

        ' Close the mydocument element - zamykamy element "mydocument"
        w.WriteEndElement()
        w.WriteEndDocument()

        w.Close()

    End Sub

    Private Sub cmdRead_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdRead.Click
        Dim doc As New XmlDocument()
        doc.Load("c:\test.xml")
        Dim r As XmlNodeReader = New XmlNodeReader(doc)
        ' Licznik zlicza, ile wzw odnaleziono. 
        ' Use a counter to keep track of how many nodes are found.
        Dim ElementNumber As Integer

        ' Loop until the file is finished.
        ' Ptla a do koca pliku. 
        Do
            ElementNumber += 1
            ' Display each node property, unless it's blank.
            ' Wywietlaj wasno kadego wza, jeli nie jest pusta.
            Out(ElementNumber.ToString & ". " & r.NodeType.ToString)
            If Not r.Name = "" Then Out("  Name: " & r.Name)
            If Not r.Value = "" Then Out("  Value: " & r.Value)
            If r.HasAttributes Then
                Dim i As Integer
                For i = 0 To r.AttributeCount - 1
                    r.MoveToAttribute(i)
                    ' Display the attribute's properties.
                    ' Wywietlaj wasnoci atrybutu.
                    Out("  Attribute #" & (i + 1).ToString)
                    Out("     Name: " & r.Name)
                    Out("     Value: " & r.Value)
                Next i
                r.MoveToElement()        ' Wr na pocztek elementu wyjciowego.
            End If

            Out("")
        Loop While r.Read() = True

    End Sub

    Private Sub Out(ByVal NewText As String)
        lblDisplay.Text = lblDisplay.Text & vbNewLine & NewText
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub
End Class
