Imports System.IO
Imports System.Runtime.Serialization.Formatters.Binary
Imports System.Runtime.Serialization.Formatters.Soap

Public Class Form1

    Private Sub cmdTest_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdTest.Click
        ' Create Bob and clone a copy of him into a file.
        ' Tworzymy obiekt Bob i kopiujemy jego dane do pliku.
        Dim Bob As New SerializablePerson("Bob", 34, 5.25)
        Dim fs As New FileStream("c:\bob.dat", FileMode.Create)

        Dim f As System.Runtime.Serialization.IFormatter
        If optSoap.Checked = True Then
            f = New SoapFormatter()
        Else
            f = New BinaryFormatter()
        End If

        ' Zapisujemy dane obieky Bob przy pomocy formatera BinaryFormatter.
        f.Serialize(fs, Bob)

        fs.Close()

        ' Usuwamy biec kopi obieku Bob.
        Bob = Nothing

        ' Revive Bob by using the file, and check that his data is correct.
        ' Pobieramy dane z pliku i sprawdzamy, czy s poprawne.
        fs = New FileStream("c:\bob.dat", FileMode.Open)

        ' Retrieve Bob with the help of the BinaryFormatter.
        ' Pobieramy dane przy pomocy formatera binarnego.
        Bob = CType(f.Deserialize(fs), SerializablePerson)

        ' Sprawdzmy poprawno danych.
        MessageBox.Show(Bob.Name)
        fs.Close()
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub
End Class
