Imports Microsoft.Win32
Public Class RegistryReader

    Public Shared Sub SaveSize(ByVal frm As System.Windows.Forms.Form)

        ' The next line creates the key only if it doesn't already exist.
        Dim rk As RegistryKey
        rk = Registry.LocalMachine.CreateSubKey( _
             "Software\Acme\TestApp\" & frm.Name)
        rk.SetValue("Height", frm.Height)
        rk.SetValue("Width", frm.Width)
        rk.SetValue("Left", frm.Left)
        rk.SetValue("Top", frm.Top)

    End Sub

    Public Shared Sub SetSize(ByVal frm As System.Windows.Forms.Form)

        Dim rk As RegistryKey
        rk = Registry.LocalMachine.OpenSubKey( _
             "Software\Acme\TestApp\" & frm.Name)

        ' If the value isn't found the second argument is used.
        ' This leaves the size and location unchanged.
        frm.Height = CType(rk.GetValue("Height", frm.Height), Integer)
        frm.Width = CType(rk.GetValue("Width", frm.Width), Integer)
        frm.Left = CType(rk.GetValue("Left", frm.Left), Integer)
        frm.Top = CType(rk.GetValue("Top", frm.Top), Integer)

    End Sub

End Class

