Imports System.IO

Public Class Form1

    Private Sub Fill(ByVal Dir As DirectoryInfo, ByVal DirNode As TreeNode)

        ' An exception could be thrown in this code if you don't
        ' have sufficient security exceptions for a file or directory.
        ' You can catch and then ignore this exception.
        ' Jeli nie zachowany ostronoci odnonie ogranicze naoonych na pliki i katalogi,
        ' kod ten moe spowodowa wystpienie wyjtku.
        ' Moemy przechwyci obsug tego wyjtku a nastpnie go zignorowa.
        Try
            For Each DirItem As DirectoryInfo In Dir.GetDirectories
                ' Add node for the directory - dodaj wze dla folderu
                Dim NewNode As New TreeNode(DirItem.Name)
                DirNode.Nodes.Add(NewNode)

                ' Use a * as a placeholder for directories that haven't been filled in yet.
                ' Stosujemy znak gwiazdki * do zastpienia jeszcze nie wypenionych katalogw.
                NewNode.Nodes.Add("*")
            Next
        Catch
        End Try
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Fill just the first level - wypenij tylko pierwszy poziom.
        Dim RootDir As New DirectoryInfo("c:\")
        Dim RootNode As New TreeNode("c:\")
        treeFiles.Nodes.Add(RootNode)
        Fill(RootDir, RootNode)
    End Sub

    Private Sub treeFiles_BeforeExpand(ByVal sender As System.Object, ByVal e As System.Windows.Forms.TreeViewCancelEventArgs) Handles treeFiles.BeforeExpand
        If e.Node.Nodes.Count > 0 Then
            If e.Node.FirstNode.Text = "*" Then
                ' Replace the placeholder with a just-in-time list of directories.
                ' Zastpujemy * biec list folderw.
                e.Node.FirstNode.Remove()
                Dim DirectoryToFill As New DirectoryInfo(e.Node.FullPath)
                Fill(DirectoryToFill, e.Node)
            End If
        End If
    End Sub

    Private Sub treeFiles_AfterSelect(ByVal sender As System.Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles treeFiles.AfterSelect

    End Sub

    Private Sub lstFiles_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lstFiles.SelectedIndexChanged
        Dim RootDrive4 As New DirectoryInfo("c:\")
        Dim FileArray() As FileInfo
        FileArray = RootDrive.GetFiles()
        Dim i As Integer
        For i = 0 To FileArray.GetUpperBound(0) - 1
            lstFiles.Items(i) = ToText(FileArray(i).Name)
        Next
    End Sub

    Private Sub SplitContainer1_SplitterMoved(ByVal sender As System.Object, ByVal e As System.Windows.Forms.SplitterEventArgs) Handles SplitContainer1.SplitterMoved

    End Sub
End Class
