Imports System.IO

Public Class ExceptionTester

    Private Sub cmdThrow_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdThrow.Click
        Dim FileLine As String
        Dim FileStream As System.IO.StreamReader


        Try
            ' Ten kod moe spowodowa wystpienie problemu... 
            ' does_not_exist to plik, ktrego nie ma.
            FileStream = System.IO.File.OpenText("does_not_exist.txt")
            FileLine = FileStream.ReadLine()

        Catch MyError As Exception
            ' Jeli wystpi bd znajdziemy si tu.

            DisplayError(MyError)

        Finally
            ' A tu znajdziemy si zawsze, bez wzgldu na to, co si stao.
            If Not FileStream Is Nothing Then
                FileStream.Close()   ' Zamknicie pliku.
            End If
        End Try

    End Sub


    Private Sub cmdThrowCustom_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdThrowCustom.Click

        ' Nieprowidowe dane.
        Dim IsPetOwner As Boolean = False     ' jest wacicielem psa? - nie.
        Dim PetBreed As String = "Daschund"   ' rasa psa, jak pudel, tylko wikszy.  

        Try
            Dim MyError As New ConflictingDBDataException("Problem z psem.")
            MyError.InvalidFields.Add("IsPetOwner", IsPetOwner)
            MyError.InvalidFields.Add("PetBreed", PetBreed)
            Throw MyError
        Catch MyError As ConflictingDBDataException
            DisplayError(MyError)
            MessageBox.Show("Liczba nieprowidowych porcji danych: " & MyError.InvalidFields.Count)
        End Try

    End Sub

    Private Sub DisplayError(ByVal Err As Exception)
        Dim Spacer As New String("-", 150)
        Spacer = vbNewLine & Spacer & vbNewLine

        Dim Message As String
        Message = "Rodzaj wyjtku - Exception Type" & Spacer
        Message &= Err.GetType().ToString() & vbNewLine & vbNewLine
        Message &= "Komunikat" & Spacer
        Message &= Err.Message & vbNewLine & vbNewLine
        Message &= "ledzenie stosu - Stack Trace" & Spacer
        Message &= Err.StackTrace

        MessageBox.Show(Message, "Wystpi wyjtek.")

    End Sub

    Private Sub cmdFail_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdFail.Click
        Dim Balance As Integer = 0

        ' This is false, which means the assertion will fail.
        ' To fasz, co oznacza, e asercja nie jest speniona. 
        Debug.Assert(Balance > 0)
    End Sub

    Private Sub cmdDebug_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdDebug.Click

        Dim i As Integer
        Dim Info() As String = {"To", "jest", "tylko", "prosty", "test", "okna", "diagnostycznego", "debug", "output", "window.", ""}
        For i = 0 To 10
            Debug.WriteLine("Liczba iteracji " & i.ToString & ". Odczyt: " & Info(i))
        Next i
    End Sub

    Private Sub cmdTrace_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdTrace.Click

        ' Jeli taki plik istnieje, zostanie usunity.
        Trace.Listeners.Clear()
        If File.Exists("c:\output.txt") Then
            File.Delete("c:\output.txt")
        End If

        ' Inicjowanie pliku rejestru.
        Dim FileListener As New TextWriterTraceListener(File.Create("c:\output.txt"))
        Trace.Listeners.Add(FileListener)
        Trace.AutoFlush = True

        ' ledzenie.
        Trace.WriteLine("Start aplikacji")
        Trace.Indent() ' To dobry przykad prowidowo zorganizowanego wyjcia.
        Trace.WriteLine("Wykonuje jakie zadania . . .")
        ' To mona doda jaki kod.
        Trace.WriteLine("Zakoczyem wykonanie zadania.")
        Trace.Unindent()
        Trace.WriteLine("Wykonane.")

        ' To zazwyczaj wykonuje si na kocu programu.
        Trace.Listeners(0).Close()

        MessageBox.Show("Plik rejestru - Log utworzono jako c:\output.txt.")

    End Sub

    Private Sub cmdThrowUnhandled_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdThrowUnhandled.Click
        Throw New ApplicationException( _
         "To powinno spowodowa zakoczenie aplikacji, chyba e " & _
         "nieobsugiwany wyjtek UnhandledException application event zostaby obsuony.")
    End Sub
End Class

