Public Class Reflector

    Private Sub cmdReflect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdReflect.Click
        treeTypes.Nodes.Clear()

        Dim MyAssembly As System.Reflection.Assembly
        MyAssembly = System.Reflection.Assembly.GetExecutingAssembly()
        lblAssembly.Text = MyAssembly.FullName

        ' Define some variables used to "walk" the program structure.
        ' Definiujemy pewne zmienne pomocnicze do "inspekcji" struktury programu
        Dim MyTypes(), MyType As Type
        Dim MyEvents(), MyEvent As System.Reflection.EventInfo
        Dim MyMethods(), MyMethod As System.Reflection.MethodInfo
        Dim MyProperties(), MyProperty As System.Reflection.PropertyInfo

        ' Iterate through the program's classes.
        ' Iteracja poprzez klasy nalece do programu
        MyTypes = MyAssembly.GetTypes()
        For Each MyType In MyTypes
            Dim nodeParent As TreeNode = treeTypes.Nodes.Add(MyType.FullName)

            ' Iterate through the events in each class.
            ' Przegladamy zdarzenia w kadej z klas
            Dim node As TreeNode = nodeParent.Nodes.Add("Events")
            MyEvents = MyType.GetEvents
            For Each MyEvent In MyEvents
                node.Nodes.Add(MyEvent.Name & " - event handler signature: " & _
                 MyEvent.EventHandlerType.Name)
            Next

            ' Iterate through the methods in each class.
            ' Przegladamy metody w kadej z klas
            node = nodeParent.Nodes.Add("Methods")
            MyMethods = MyType.GetMethods()
            For Each MyMethod In MyMethods
                node.Nodes.Add(MyMethod.Name)
            Next

            ' Iterate through the properties in each class.
            ' Przegladamy metody kadej z klas
            node = nodeParent.Nodes.Add("Properties")
            MyProperties = MyType.GetProperties
            For Each MyProperty In MyProperties
                node.Nodes.Add(MyProperty.Name & "- data type: " & _
                MyProperty.PropertyType.ToString())
            Next
        Next

    End Sub

    Private Sub lblAssembly_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lblAssembly.Click

    End Sub
End Class