Public Class EventTestForm
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Friend WithEvents txtFirstName As System.Windows.Forms.TextBox
    Friend WithEvents txtLastName As System.Windows.Forms.TextBox
    Friend WithEvents dtBirth As System.Windows.Forms.DateTimePicker
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents cmdClose As System.Windows.Forms.Button
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents txtNewFirst As System.Windows.Forms.TextBox
    Friend WithEvents cmdUpdate As System.Windows.Forms.Button
        Friend WithEvents Label5 As System.Windows.Forms.Label

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.Container

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.cmdUpdate = New System.Windows.Forms.Button
        Me.Label2 = New System.Windows.Forms.Label
        Me.Label3 = New System.Windows.Forms.Label
        Me.cmdClose = New System.Windows.Forms.Button
        Me.Label1 = New System.Windows.Forms.Label
        Me.txtLastName = New System.Windows.Forms.TextBox
        Me.txtFirstName = New System.Windows.Forms.TextBox
        Me.GroupBox1 = New System.Windows.Forms.GroupBox
        Me.txtNewFirst = New System.Windows.Forms.TextBox
        Me.Label5 = New System.Windows.Forms.Label
        Me.dtBirth = New System.Windows.Forms.DateTimePicker
        Me.GroupBox1.SuspendLayout()
        Me.SuspendLayout()
        '
        'cmdUpdate
        '
        Me.cmdUpdate.Location = New System.Drawing.Point(184, 64)
        Me.cmdUpdate.Name = "cmdUpdate"
        Me.cmdUpdate.Size = New System.Drawing.Size(68, 20)
        Me.cmdUpdate.TabIndex = 4
        Me.cmdUpdate.Text = "Aktualizuj"
        '
        'Label2
        '
        Me.Label2.Font = New System.Drawing.Font("Tahoma", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label2.Location = New System.Drawing.Point(24, 60)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(104, 16)
        Me.Label2.TabIndex = 2
        Me.Label2.Text = "Nazwisko:"
        '
        'Label3
        '
        Me.Label3.Font = New System.Drawing.Font("Tahoma", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label3.Location = New System.Drawing.Point(24, 92)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(104, 16)
        Me.Label3.TabIndex = 2
        Me.Label3.Text = "Data urodzenia:"
        '
        'cmdClose
        '
        Me.cmdClose.Location = New System.Drawing.Point(104, 264)
        Me.cmdClose.Name = "cmdClose"
        Me.cmdClose.Size = New System.Drawing.Size(104, 28)
        Me.cmdClose.TabIndex = 3
        Me.cmdClose.Text = "Zamknij"
        '
        'Label1
        '
        Me.Label1.Font = New System.Drawing.Font("Tahoma", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label1.Location = New System.Drawing.Point(24, 32)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(104, 16)
        Me.Label1.TabIndex = 2
        Me.Label1.Text = "Imi:"
        '
        'txtLastName
        '
        Me.txtLastName.Font = New System.Drawing.Font("Tahoma", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.txtLastName.Location = New System.Drawing.Point(128, 56)
        Me.txtLastName.Name = "txtLastName"
        Me.txtLastName.ReadOnly = True
        Me.txtLastName.Size = New System.Drawing.Size(144, 21)
        Me.txtLastName.TabIndex = 0
        '
        'txtFirstName
        '
        Me.txtFirstName.Font = New System.Drawing.Font("Tahoma", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.txtFirstName.Location = New System.Drawing.Point(128, 28)
        Me.txtFirstName.Name = "txtFirstName"
        Me.txtFirstName.ReadOnly = True
        Me.txtFirstName.Size = New System.Drawing.Size(144, 21)
        Me.txtFirstName.TabIndex = 0
        '
        'GroupBox1
        '
        Me.GroupBox1.Controls.Add(Me.txtNewFirst)
        Me.GroupBox1.Controls.Add(Me.cmdUpdate)
        Me.GroupBox1.Controls.Add(Me.Label5)
        Me.GroupBox1.Location = New System.Drawing.Point(16, 132)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(276, 100)
        Me.GroupBox1.TabIndex = 5
        Me.GroupBox1.TabStop = False
        Me.GroupBox1.Text = "Zmiana imienia"
        '
        'txtNewFirst
        '
        Me.txtNewFirst.Font = New System.Drawing.Font("Tahoma", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.txtNewFirst.Location = New System.Drawing.Point(112, 32)
        Me.txtNewFirst.Name = "txtNewFirst"
        Me.txtNewFirst.Size = New System.Drawing.Size(144, 21)
        Me.txtNewFirst.TabIndex = 0
        '
        'Label5
        '
        Me.Label5.Font = New System.Drawing.Font("Tahoma", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label5.Location = New System.Drawing.Point(12, 32)
        Me.Label5.Name = "Label5"
        Me.Label5.Size = New System.Drawing.Size(104, 16)
        Me.Label5.TabIndex = 2
        Me.Label5.Text = "Imi:"
        '
        'dtBirth
        '
        Me.dtBirth.Enabled = False
        Me.dtBirth.Font = New System.Drawing.Font("Tahoma", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.dtBirth.Format = System.Windows.Forms.DateTimePickerFormat.[Short]
        Me.dtBirth.Location = New System.Drawing.Point(128, 88)
        Me.dtBirth.Name = "dtBirth"
        Me.dtBirth.Size = New System.Drawing.Size(148, 21)
        Me.dtBirth.TabIndex = 1
        '
        'EventTestForm
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 14)
        Me.ClientSize = New System.Drawing.Size(316, 306)
        Me.Controls.Add(Me.GroupBox1)
        Me.Controls.Add(Me.Label1)
        Me.Controls.Add(Me.txtLastName)
        Me.Controls.Add(Me.dtBirth)
        Me.Controls.Add(Me.Label3)
        Me.Controls.Add(Me.cmdClose)
        Me.Controls.Add(Me.Label2)
        Me.Controls.Add(Me.txtFirstName)
        Me.Font = New System.Drawing.Font("Tahoma", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Name = "EventTestForm"
        Me.Text = "Event Tester"
        Me.GroupBox1.ResumeLayout(False)
        Me.GroupBox1.PerformLayout()
        Me.ResumeLayout(False)
        Me.PerformLayout()

    End Sub

#End Region

    ' Create the Person as a form-level variable.
    ' Tworzymy obiekt klasy Person jako lokaln zmienn na poziomie formularza
    Private WithEvents CurrentPerson As New Person("Lucy", "Smith", DateTime.Now)

    ' This event handler updates the window when the form is loaded.
    ' Ten handler zdarzenia aktualizuje zawarto okna w chwili adowania formularza
    Private Sub frmClassTester_Load(ByVal sender As System.Object, _
     ByVal e As System.EventArgs) Handles MyBase.Load
        txtFirstName.Text = CurrentPerson.FirstName
        txtLastName.Text = CurrentPerson.LastName
        dtBirth.Value = CurrentPerson.BirthDate
    End Sub

    Private Sub RefreshData(ByVal sender As Object, ByVal e As PersonChangedEventArgs) Handles CurrentPerson.PersonChanged
        Select Case e.ChangedProperty
            Case Person.ChangedProperty.FirstName
                txtFirstName.Text = CurrentPerson.FirstName
            Case Person.ChangedProperty.LastName
                txtLastName.Text = CurrentPerson.LastName
            Case Person.ChangedProperty.BirthDate
                dtBirth.Value = CurrentPerson.BirthDate
        End Select
    End Sub

    Private Sub cmdClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdClose.Click
        Me.Close()
    End Sub

    Private Sub cmdUpdate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdUpdate.Click
        CurrentPerson.FirstName = txtNewFirst.Text
    End Sub

    Private Sub Label1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Label1.Click

    End Sub
End Class


Public Class Person

    Public Enum ChangedProperty
        FirstName
        LastName
        BirthDate
    End Enum

    Public Event PersonChanged(ByVal sender As Object, ByVal e As PersonChangedEventArgs)

    ' Data for the Person
    Private _FirstName As String
    Private _LastName As String
    Private _BirthDate As Date

    Public Property FirstName() As String
        Get
            Return _FirstName
        End Get

        Set(ByVal Value As String)
            _FirstName = Value
            RaiseEvent PersonChanged(Me, New PersonChangedEventArgs(ChangedProperty.FirstName))
        End Set
    End Property

    Public Property LastName() As String
        Get
            Return _LastName
        End Get

        Set(ByVal Value As String)
            _LastName = Value
            RaiseEvent PersonChanged(Me, New PersonChangedEventArgs(ChangedProperty.LastName))
        End Set
    End Property

    Public ReadOnly Property BirthDate() As Date
        Get
            Return _BirthDate
        End Get
    End Property

    ' Constructors - konstruktory 
    Public Sub New(ByVal FirstName As String, ByVal LastName As String, _
     ByVal BirthDate As Date)
        _FirstName = FirstName
        _LastName = LastName
        _BirthDate = BirthDate
    End Sub

    Public Sub New(ByVal FirstName As String, ByVal LastName As String)
        _FirstName = FirstName
        _LastName = LastName
        _BirthDate = DateTime.Now
    End Sub

    Public Sub New(ByVal FirstName As String, ByVal LastName As String, _
     ByVal Age As Integer)
        _FirstName = FirstName
        _LastName = LastName
        _BirthDate = DateTime.Now.AddYears(-Age)
    End Sub

    ' Built-in feature to get the Person object to introduce itself.
    ' Wbudowana cecha - by obiekt mg sam si przedstawi:
    ' Nazywam si .... urodziem si ...
    Public Function GetIntroduction() As String
        Dim Intro As String
        Intro = "My name is " & FirstName & " " & LastName & ". "
        Intro &= "I was born on " & BirthDate.ToString
        Return Intro
    End Function

End Class

Public Class PersonChangedEventArgs
    Inherits EventArgs

    Private _ChangedProperty As Person.ChangedProperty
    Public Property ChangedProperty() As Person.ChangedProperty
        Get
            Return _ChangedProperty
        End Get
        Set(ByVal Value As Person.ChangedProperty)
            _ChangedProperty = Value
        End Set
    End Property

    Public Sub New(ByVal ChangedProperty As Person.ChangedProperty)
        _ChangedProperty = ChangedProperty
    End Sub
End Class