Public Class Form1

    Private ServiceInstance As New localhost.PostalWebService()

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Doczenie metody obsugi zdarzenia
        ' dla asynchronicznego wywoania.
        AddHandler ServiceInstance.GetPackageInfoCompleted, AddressOf GetPackageInfoCompleted
    End Sub


    Private Sub cmdGetInfo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdGetInfo.Click
        Me.Cursor = Cursors.WaitCursor

        Dim PackageInfo As New localhost.ClientPackageInfo()
        PackageInfo = ServiceInstance.GetPackageInfo("221")
        MessageBox.Show("Pobrano dat dostarczenia: " & PackageInfo.DeliveryDate, "Dane z usugi sieciowej!")

        Me.Cursor = Me.DefaultCursor
    End Sub

    Private Sub cmdGetAsync_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdGetAsync.Click
        ' Wyczenie przycisku, aby pozwoli na tylko jedno
        ' wywoanie asynchroniczne naraz.
        cmdGetAsync.Enabled = False

        ' Uruchamianie wywoania asynchronicznego.
        ' Ta metoda nie blokuje dziaania kodu.
        ServiceInstance.GetPackageInfoAsync("Call001", "Call001")

        ' Umoliwienie anulowania.
        cmdCancelAsync.Enabled = True
    End Sub

    Private Sub GetPackageInfoCompleted(ByVal sender As Object, ByVal e As localhost.GetPackageInfoCompletedEventArgs)
        If Not e.Cancelled Then
            MessageBox.Show("Pobrano dat dostarczenia: " & e.Result.DeliveryDate)
        End If

        ' W kadym przypadku naley ponownie wczy przycisk, aby umoliwi nastpne 
        ' wywoanie.
        cmdGetAsync.Enabled = True
    End Sub

    Private Sub cmdCancelAsync_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdCancelAsync.Click
        ServiceInstance.CancelAsync("Call001")
        cmdCancelAsync.Enabled = False
    End Sub
End Class
