Imports System.Threading

Public Class ThreadPriorityTester
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents tmrThreadMonitor As System.Windows.Forms.Timer
    Private components As System.ComponentModel.IContainer
    Friend WithEvents lblThreads As System.Windows.Forms.Label
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents txtMax As System.Windows.Forms.TextBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents lstPriorities As System.Windows.Forms.ComboBox
    Friend WithEvents cmdNew As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Me.tmrThreadMonitor = New System.Windows.Forms.Timer(Me.components)
        Me.lblThreads = New System.Windows.Forms.Label
        Me.GroupBox1 = New System.Windows.Forms.GroupBox
        Me.Label2 = New System.Windows.Forms.Label
        Me.txtMax = New System.Windows.Forms.TextBox
        Me.Label1 = New System.Windows.Forms.Label
        Me.lstPriorities = New System.Windows.Forms.ComboBox
        Me.cmdNew = New System.Windows.Forms.Button
        Me.GroupBox1.SuspendLayout()
        Me.SuspendLayout()
        '
        'tmrThreadMonitor
        '
        Me.tmrThreadMonitor.Interval = 1000
        '
        'lblThreads
        '
        Me.lblThreads.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.lblThreads.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.lblThreads.Location = New System.Drawing.Point(8, 8)
        Me.lblThreads.Name = "lblThreads"
        Me.lblThreads.Size = New System.Drawing.Size(240, 228)
        Me.lblThreads.TabIndex = 6
        '
        'GroupBox1
        '
        Me.GroupBox1.Anchor = CType(((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.GroupBox1.Controls.Add(Me.Label2)
        Me.GroupBox1.Controls.Add(Me.txtMax)
        Me.GroupBox1.Controls.Add(Me.Label1)
        Me.GroupBox1.Controls.Add(Me.lstPriorities)
        Me.GroupBox1.Controls.Add(Me.cmdNew)
        Me.GroupBox1.Location = New System.Drawing.Point(252, 0)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(224, 236)
        Me.GroupBox1.TabIndex = 9
        Me.GroupBox1.TabStop = False
        '
        'Label2
        '
        Me.Label2.Location = New System.Drawing.Point(6, 71)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(90, 32)
        Me.Label2.TabIndex = 13
        Me.Label2.Text = "Maksymalna warto licznika:"
        '
        'txtMax
        '
        Me.txtMax.Location = New System.Drawing.Point(104, 71)
        Me.txtMax.Name = "txtMax"
        Me.txtMax.Size = New System.Drawing.Size(88, 21)
        Me.txtMax.TabIndex = 12
        Me.txtMax.Text = "1000000000"
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(6, 42)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(90, 16)
        Me.Label1.TabIndex = 10
        Me.Label1.Text = "Priorytet:"
        '
        'lstPriorities
        '
        Me.lstPriorities.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList
        Me.lstPriorities.DropDownWidth = 88
        Me.lstPriorities.Location = New System.Drawing.Point(104, 37)
        Me.lstPriorities.Name = "lstPriorities"
        Me.lstPriorities.Size = New System.Drawing.Size(88, 21)
        Me.lstPriorities.TabIndex = 11
        '
        'cmdNew
        '
        Me.cmdNew.Location = New System.Drawing.Point(104, 112)
        Me.cmdNew.Name = "cmdNew"
        Me.cmdNew.Size = New System.Drawing.Size(88, 24)
        Me.cmdNew.TabIndex = 9
        Me.cmdNew.Text = "Uruchom nowy"
        '
        'ThreadPriorityTester
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 14)
        Me.ClientSize = New System.Drawing.Size(480, 246)
        Me.Controls.Add(Me.GroupBox1)
        Me.Controls.Add(Me.lblThreads)
        Me.Font = New System.Drawing.Font("Tahoma", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Name = "ThreadPriorityTester"
        Me.Text = "Tester priorytetw wtkw"
        Me.GroupBox1.ResumeLayout(False)
        Me.GroupBox1.PerformLayout()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private ActiveThreads As New Collection()
    Private ActiveCounters As New Collection()
    Private ThreadNumber As Integer = 0

    Private Sub ThreadPriorityTester_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        lstPriorities.Items.Add(ThreadPriority.Lowest)
        lstPriorities.Items.Add(ThreadPriority.BelowNormal)
        lstPriorities.Items.Add(ThreadPriority.Normal)
        lstPriorities.Items.Add(ThreadPriority.AboveNormal)
        lstPriorities.Items.Add(ThreadPriority.Highest)
        lstPriorities.SelectedIndex = 0
    End Sub


    Private Sub cmdNew_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdNew.Click

        Dim Counter As New ThreadCounter(Val(txtMax.Text), lstPriorities.Text)
        ThreadNumber += 1

        Dim CounterThread As New Thread(AddressOf Counter.Refresh)
        CounterThread.Priority = CType(lstPriorities.SelectedItem, ThreadPriority)
        CounterThread.Name = "Wtek licznika nr " & ThreadNumber.ToString()
        CounterThread.Start()

        ActiveCounters.Add(Counter)
        ActiveThreads.Add(CounterThread)
        tmrThreadMonitor.Enabled = True

    End Sub


    Private Sub tmrThreadMonitor_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrThreadMonitor.Tick
        lblThreads.Text = ""
        Dim Counter As ThreadCounter
        Dim i As Integer
        For Each Counter In ActiveCounters
            i += 1
            lblThreads.Text &= "Nr " & i.ToString() & " na: "
            lblThreads.Text &= Counter.LoopCount.ToString() & " ("
            lblThreads.Text &= Counter.Priority & ")"
            lblThreads.Text &= vbNewLine
        Next
    End Sub

    Private Sub ThreadPriorityTester_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing

        ' Sygnalizuje zatrzymanie kadego wtku.
        Dim Counter As ThreadCounter
        For Each Counter In ActiveCounters
            Counter.ThreadStop = True
        Next

        ' Oczekiwanie na sprawdzenie zatrzymania wszystkich wtkw.
        Dim CounterThread As Thread
        For Each CounterThread In ActiveThreads
            CounterThread.Join()
        Next

    End Sub

End Class

Public Class ThreadCounter

    Public LoopCount As Int64
    Public MaxValue As Int64
    Public Priority As String
    Public ThreadStop As Boolean

    Public Sub New(ByVal MaxValue As Int64, ByVal Priority As String)
        Me.MaxValue = MaxValue
        Me.Priority = Priority
    End Sub

    Public Sub Refresh()
        ' Zwikszanie licznika.
        For LoopCount = 0 To MaxValue - 1
            ' Sprawdzanie sygnau natychmiast zatrzymujcego wtek.
            If ThreadStop = True Then Exit For

            ' Umoliwia bardziej pynne dziaanie aktualizujcego kodu
            ' poprzez okazjonalne przerw w dziaaniu.
            If LoopCount Mod 1000000 = 0 Then Thread.Sleep(1)
        Next
    End Sub

End Class