Imports System.Data.SqlClient

Public Class Relation
    Private Sub cmdFill_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdFill.Click

        Dim Connect As String = "Data Source=localhost;Integrated Security=True;" & _
          "Initial Catalog=Northwind;"
        Dim con As New SqlConnection(Connect)

        Dim SQL As String = "SELECT * FROM Orders " & _
         "WHERE OrderDate < '2000/01/01' AND OrderDate > '1987/01/01'"
        Dim cmd As New SqlCommand(SQL, con)

        Dim adapter As New SqlDataAdapter(cmd)
        Dim dsNorthwind As New DataSet()

        con.Open()

        adapter.Fill(dsNorthwind, "Orders")

        ' To polecenie jest wci poczone z adapterem danych.
        cmd.CommandText = "SELECT * FROM Customers"
        adapter.Fill(dsNorthwind, "Customers")

        cmd.CommandText = "SELECT * FROM Employees"
        adapter.Fill(dsNorthwind, "Employees")

        con.Close()

        ' Definiowanie relacji.
        Dim relCustomersOrders As New DataRelation("CustomersOrders", _
         dsNorthwind.Tables("Customers").Columns("CustomerID"), _
         dsNorthwind.Tables("Orders").Columns("CustomerID"))

        ' Dodawanie relacji do obiektu DataSet.
        dsNorthwind.Relations.Add(relCustomersOrders)

        Dim nodeParent, nodeChild As TreeNode
        Dim rowParent, rowChild As DataRow

        For Each rowParent In dsNorthwind.Tables("Customers").Rows

            ' Dodawanie wza klienta.
            nodeParent = treeDB.Nodes.Add(rowParent("CompanyName"))

            ' Zapisywanie odczonych informacji o kliencie w celu ich pniejszego wykorzystania.
            nodeParent.Tag = rowParent

            For Each rowChild In rowParent.GetChildRows(relCustomersOrders)
                ' Dodawanie wza podrzdnego z zamwieniem.
                nodeChild = nodeParent.Nodes.Add(rowChild("OrderID"))

                ' Zapisywanie odczonych informacji o zamwieniu w celu ich pniejszego wykorzystania.
                nodeChild.Tag = rowChild
            Next
        Next

    End Sub

    Private Sub cmdClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdClear.Click
        treeDB.Nodes.Clear()
    End Sub

    Private Sub treeDB_AfterSelect(ByVal sender As System.Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles treeDB.AfterSelect

        ' Czyszczenie pola tekstowego
        txtInfo.Text = ""
        Dim row As DataRow = CType(e.Node.Tag, DataRow)

        ' Zapenianie pola tekstowego informacjami z kadego pola
        Dim Field As Object
        For Each Field In row.ItemArray
            txtInfo.Text &= Field.ToString & vbNewLine
        Next

    End Sub
End Class